#! /usr/bin/zsh -f

# script lisant un fichier *%%COLL.asc en entree standard et determinant qq statistiques sur les collisions

gawk '
    BEGIN{
	NbColl=0;NbCoal=0;NbDestrTot=0;NbDisrByCompact=0
	OFS="\t"
	print "iPas_evol","NbColl","NbCoal","NbDestrTot","NbDisrByCO"
	print "---------","------","------","----------","----------"
    }
    /^[^#]/ && (NF==14 || NF==18 || NF==20){
	iPas_evol=$1
	NbColl++
	Netoiles=0
        Type1=$5; Type2=$6
	if (NF==14 || NF==20) { # nouveau format sans les rayons
	    Mfin1=$11; Mfin2=$12;
	}
        if (NF==18){      # ancien format
	    Mfin1=$13; Mfin2=$14;
	}
	if (Mfin1>1e-6) { Netoiles++ }
	if (Mfin2>1e-6) { Netoiles++ }
	if (Netoiles==1) {
             if (Type1==Type2 && Type1<5) { 
                  NbCoal++ 
             } else {
                 if ((Type1<3 && Type2>=3) || (Type1<3 && Type2>=3) ) { # disruption by compact star
                     NbDisrByCompact++ 
                 }
             }
        } else { 
             if (Netoiles==0) { NbDestrTot++ } 
        }
	print iPas_evol,NbColl,NbCoal,NbDestrTot,NbDisrByCompact
    }
'
