#!/usr/bin/ksh

# lit la suite des fichiers $1_nnnn.asc et fait une table /rdb
# des energies

NomBase=$1

head -n12 $(
	ls -1 $NomBase"_"*".asc" | grep -E "^$NomBase"_"[0-9]+\.asc\$" | sort
)	|\
gawk '
	BEGIN{
		OFS="\t"
		print "NbSE","Mamas","MTN","Tamas","Egrav","Ecin","Etot"
		print "----","-----","---","-----","-----","----","----"
	}

	/Nb SuperEtoiles/ 	 {NbSE=$NF}
	/Masse Amas/ 	   	 {Mamas=$NF}
	/Masse trou noir/	 {MTN=$NF}
	/Instant  t/		 {Tamas=$NF}
	/Energie grav, cin, tot/ {Egrav=$(NF-5); Ecin=$(NF-3); Etot=$(NF-1); tout=1}
	{if (tout==1) {print NbSE,Mamas,MTN,Tamas,Egrav,Ecin,Etot; tout=0}}
'	|\
addcol Viriel | compute 'Viriel=(2*Ecin+Egrav)/sqrt(Etot*Etot)'
