#!/usr/bin/env zsh

cat <<EOF

\begin{table*}%[t]
\begin{center}
\begin{tabular}{llllp{15cm}}
\hline
\hline
 & Parameter &Type& Default& Explanation\\\\
\hline
EOF

headoff |\
sed 's/\([a-zA-Z][a-zA-Z0-9_]*\*[a-zA-Z][a-zA-Z0-9_]*\)/\\verb\|\1\|/' |\
sed 's/\"\([a-zA-Z][a-zA-Z0-9_.]*\)\"/\\verb\|\1\|/' |\
gawk 'BEGIN{FS="\t"}
  {
    Param=$1; Type=$2; Default=$3; Comment=$4
    sub(/double precision/,"r*8",Type)
    sub(/integer/,"i",Type)
    sub(/byte/,"b",Type)
    sub(/character/,"c",Type)
    #gsub(/\//,"\\/",Comment)
    gsub(/_/,"\\_",Comment)
    print "  &\\verb|"Param"| & "Type" & \\verb|"Default"| & "Comment" \\\\"
  }
'

cat <<EOF
\hline
\end{tabular}
\caption{Parameters in {\tt input\_EvolAmas}.
\label{t:param}}
\end{center}
\end{table*}
EOF

exit 




