#!/usr/bin/zsh

# Use stellar data (initial stellar types and masses) to *%%Evap.asc file
# Only makes sense for simulations without stellar evolution!

tmp=/tmp/tmp_$$

catz.sh _EvolAmas%%Evap.asc(|.gz|.bz2) | fort2rdb.sh | sorttable -n iSE > $tmp || {
    print -u2 "!!! No evaporation file !!!"
    exit 1
}

if [[ -f _EvolAmas%0000000000%ETOILES.xdr ]]; then
    ln -s _EvolAmas%0000000000%ETOILES.xdr tmp_$$_ETOILES.xdr
else
    if [[ -f _EvolAmas%0000000000%ETOILES.xdr.gz ]]; then
	gunzip --to-stdout _EvolAmas%0000000000%ETOILES.xdr.gz > tmp_$$_ETOILES.xdr
    else
	print -u2 "!!! No ETOILES file !!!"
	rm $tmp
	exit 1
    fi
fi

etoiles_xdr2rdb.sh tmp_$$_ETOILES.xdr

cat <<EOF
# Donnees sur les SE parties par evaporation
# Type_Evap = 1 -> Evap. apres rencontre 2-corps
#             2 -> Evap. due au chgt du pot (Determiner_SE_liees)
#
# **** Stellar data added with $0 ****
#
EOF

cat tmp_$$_ETOILES.rdb | Number | rename Number iSE | jointable -a1 -n -j iSE $tmp - | sorttable -n iPas_Evol |\
column_rdb iPas_Evol Type_Evap iSE M R Ecin Egrav J iTet_SE Met_SE | rdb2fort.sh

rm $tmp tmp_$$_ETOILES.xdr
    