#!/bin/zsh

Files=( $(ls -1 *ETOILES.xdr(|.gz) | sort) )
FirstFile=$Files[1]
Files=( $Files[2,$#Files] )

for File in $Files; do
    print -u2 Creating difference file for $File from $FirstFile with xdelta
    if [[ -f $File._xdelta_ ]]; then
	print -u2 "file already processed, skipped"
    else
	xdelta delta $FirstFile $File $File._xdelta_
	mv $File $File.BAK
	ln -s $FirstFile $File # dangerous! but most of the time the script should be applied
                               # all files contain the same information (should probably check this!)
   fi
done
