#!/usr/bin/ksh

# transforme un fichier de "rayons massiques" en fichier rdb

tmp1=tmp1_$$

C_Mar=-1

# traitement des options sur la ligne de commande
while [[ $1 = -* ]]; do
    case $1 in
        -M ) C_Mar=$2 ; shift 2 ;; # Calcul du rayon de maree
        *  )
              print -u2 "!!! option $1 illegale !!!"
              exit 1 ;;
    esac
done

gawk 'BEGIN{if('$C_Mar'<=0){exit 1}else{exit 0}}' && Maree=1

[[ -n $1 ]] && exec < $1

gawk '/^# 1:/ {i=1} i==1 {print}' > $tmp1

{
    # ecriture de l'en-tete
    head -1 < $tmp1 | sed '{
	s/Nb__SE-NbSE_evap/N_SE/
	s/|| *FracMasse *://
	s/[1-9][0-9]* *://g
	s/([01]\.[0-9]*)//g
	s/^[# ] *//
    }' | gawk '{
	print
	ligne="----"
	for (j=1;j<NF;j++) {
	    ligne=ligne" -----"
	}
	print ligne
    }'

    # ecriture des donnees

    # Si le fichier a ete ecrit en plusieurs fois, avec changement de format
    # (la nouvelle version du code ecrit le pas en premiere colonne)
    # il faut supprimer la premiere colonne dans les derniers enregistrements
    typeset -i NbCol
    NbCol=$(sed -n '2p' < $tmp1 | wc -w)
    cat $tmp1 | grep -v '^#' | gawk -v NC=$NbCol 'NF>NC {sub(/^ *[0-9][0-9]* /," ",$0)}{print}'
} |\
\
sed 's/   */ /g; s/ *$//; s/^  *//' | tr ' ' '\011' |\
\
Number | sorttable -nr Number | addcol _OK_ |\
compute '{if((i_prec=="" || iPas_Evol<=i_prec) && iPas_Evol>=0){_OK_=1;i_prec=iPas_Evol}}' |\
row '_OK_==1' | sorttable -n Number | rmcol Number _OK_ |\
\
if [[ -n ${Maree:+1} ]]; then # calcul du rayon de maree
    addcol R1000 | compute '{R1000='$C_Mar'*M_liee^0.3333333}' # et le TN dans tout ca ?????
else
    cat
fi

rm $tmp1

