#!/usr/bin/ksh

# lance des simulations d'amas sans relaxation avec des Npart de + en + gd

ListeNb=${@:-"125 250 500 1000 2000 4000 8000 16000 32000 64000 128000"}
ParamFD=10
NomBase="king_"$ParamFD"_"

iDimSE=200000

for NbSE in $ListeNb; do

	NbSE_Str=$(print $NbSE | sed 's/000000/M/; s/000$/k/')
	NomAmasIn=$NomBase$NbSE_Str
	NomFichEvol="Evol_"$NomAmasIn
	NbPasEvol=$(( 100 * NbSE ))
	FreqDump=$(( 50 * NbSE ))
	FreqRecArbre=$(( 10 * NbSE ))
	if (( ( 2 * FreqRecArbre + NbSE ) > iDimSE )); then
		FreqRecArbre=$(calc.sh "0.5*($iDimSE-$NbSE)-1000")
	fi	
	cat evol.input_template | sed "\
		s/<<NomAmasIn>>/$NomAmasIn/; 		\
		s/<<NomFichEvol>>/$NomFichEvol/;	\
		s/<<NbPasEvol>>/$NbPasEvol/; 		\
		s/<<FreqDump>>/$FreqDump/; 		\
		s/<<FreqRecArbre>>/$FreqRecArbre/; 	\
	" | lance_evolamas.sh
done
