#!/usr/bin/zsh

# From Splotch files (NBODY simulation), produce a 2-column file
# with file numbers and the times in N-body units

List=( Spl(o|a)tch4_[0-9][0-9]*_part.asc(|.gz) )

for file in $List; do
    num=${file#*_}
    num=${num%%_*}
    num=$(( num + 0 ))
    time=$(gunzip -f --to-stdout $file | gawk '/^# AS =  / {print $4; exit}')
    echo $num $time
done
