#!/usr/bin/ksh 

# Nom : lance_evolamas.sh
# ###########################

# BUT        :	interface au programme d'evolution d'amas
# ===========  	formatte le fichier de parametres proprement
#	
# Appelle    :	
# -----------	

# fonction appelee a la sortie du script

function f_Sortie {
	[[ -z $pid_sim ]] || {
	    print -u2 " !!! SIMULATION EN COURS !!!"
	    print -u2 " interrompre avec _stop_.sh"
	    print "touch _STOP_\nkill -9 $pid_sim || rsh $(hostname) kill -9 $pid_sim" > _stop_.sh
	    chmod a+x _stop_.sh
	}
        rm 'tmp'?'_'$NomScript'_'$PIDScript'_tmp'?
        print -u2 $ligne_hier"====< script $NomScript termine"
	touch _STOP_
}

export ligne_hier=$ligne_hier"= "
NomScript=${0##*/}
PIDScript=$$
print -u2 $ligne_hier"====> script $NomScript"
trap  "f_Sortie" EXIT

# fichiers provisoires

tmp1=tmp1'_'$NomScript'_'$PIDScript'_'tmp1
tmp2=tmp2'_'$NomScript'_'$PIDScript'_'tmp2
touch $tmp1
#......................................................................

function f_Param_Cont {	# determine les parametres permettant de continuer
			# une simulation commence dans le repertoire courant
	# il suffit en fait de determiner le nom de la simulation et le numero
	# de la derniere sauvegarde
	ls -1 *%AMAS.bin | grep -v "^_RIP" | sort | tail -1 |\
	sed 's/%/ /g; s/ [^ ]*$//' | read NomSimul i_ini
	ListeOpt=$ListeOpt"NomSimul\n   $NomSimul\ni_ini\n   $i_ini\n"
}

function f_info {
	texte="<$(date)> $@"
	print -u2 "$texte"
	print "$texte" >> "evolamas_PROC"
}

function f_comp { # comprime les fichiers de sauvegarde au fur et a mesure de leur production
		  # laisse le dernier fichier non compresse
	until [[ -f _STOP_ ]]; do
		liste=$( ls -1 -t *_Evol_*.bin 2>/dev/null | tail +2)
		[[ -z $liste ]] || gzip $liste
		sleep 30
	done
} 

function f_Eclai { # "eclaircit" le repertoire en effacant (NEclai-1) sauvegardes
	           # sur NEclai; 
                   # si NEclai<0, ne garde que la premiere et les 2 dernieres sauvegardes
    typeset -i ic

    until [[ -f _STOP_ ]]; do
	ic=0
	until [[ -f _STOP_ ]] || (( ic == 60 )); do
	    sleep 2
	    ic=$(( ic + 1 ))
	done
	if (( NSaute == 0 )); then
	    [[ -f "$FichNSaute" ]] && NSaute =$(cat "$FichNSaute")
	fi
	(( NSaute == 0 )) && NSaute=1
	
	if (( NEclai >= 0 )); then  	
	    Liste=$(
		ls -1 *AMAS.bin |\
		gawk -v S=$NSaute -v N=$NEclai '++j>S {
		    if(++i==N && getline){
			print Liste;Liste="";i=0
		    }else{
			sub("AMAS\.bin$","*",$1);if(Liste==""){Liste=$1}else{Liste=Liste"\n"$1}
		    }
		}'
	    )	

	    [[ -z $Liste ]] || {
		rm $Liste
		NSaute=$(( NSaute + 1 ))
		print $NSaute > "$FichNSaute"
	    }
	else
	    typeset -i NSauv
	    ls -1 *AMAS.bin > $tmp2
	    NSauv=$(wc -l < $tmp2)
	    NSauv=${NSauv:-"0"}
	    Liste=$(
		cat $tmp2 | gawk -v N=$NSauv '(++i > 1) && (i < N-1) && (i < N) {
		    sub("AMAS\.bin$","*",$1); print $1
		}'
	    )
	    [[ -z $Liste ]] || rm $Liste
	    rm $tmp2
	fi 
	
    done
}

#......................................................................

NomExe=evolamas # nom de l'executable : code d'evolution d'amas
FichBlaBla=evolamas.blabla # fichier ou sont envoyes la sortie standard 
                           # et les messages d'erreur de l'executable
FichNSaute='_@NSaute@_'
Pref=""
Suf=""

# lecture des options sur la ligne de commande

ListeOpt=""
Demarre=0
Lance=1
SeTaire=0
NEclai=0
NSaute=0

while [[ $1 = -* ]]; do
	case $1 in
		-C )	f_Param_Cont || exit 1	# pour continuer la simul entammee dans
			Demarre=1		# le repertoire courant
			shift 1		;;	
		-F )	Demarre=1		# force le demarrage meme si il y a deja des
			shift 1		;;	# des fichiers d'une simulation entammee
		-X )    NomExe=$2
			shift 2		;;
		-P )	Lance=0 		# Ne lance pas la simulation !!
			shift 1		;; 	# ne fait que produire en sortie un fichier
						# d'input correct pour "evolamas"
		-O )  	ListeOpt="$ListeOpt${2%=*}\n   ${2#*=}\n"
			shift 2 	;;
		-S )	FichBlaBla=$2
			shift 2		;;
		-NS )	FichBlaBla=''
			shift 1		;;
		-N )	Pref="nice -"$2
			shift 2		;;
		-T )    SeTaire=1
			shift 1         ;;
		-E )    NEclai=$2               # "Eclaircit" le repertoire en effacant (NEclai-1) sauvegardes
			shift 2         ;;      # sur NEclai; 
                                                # si NEclai<0, ne garde que la premiere et les 2 dernieres sauvegardes
		*  )  	print -u2 "!!! option $1 incorrecte !!!"
			exit 1		;;
	esac
done

if (( (Demarre == 0) && (Lance == 1) )); then
	if [[ -z $(ls *%Log.asc *%AMAS.bin | grep -v "%000000000%") ]]; then
		Demarre=1
	else
		print -u2 '!!! Il y a deja une simulation entamee dans ce repertoire !!!'
		print -u2 '!!! employer option -F ou -C                              !!!'
		exit 1
	fi
fi
 
[[ -z $1 ]] || exec < $1 # ainsi le fichier de parametre est en entree standard
{
	sed '/#/s/#.*$//' | perl -p -e "s|\@HOME\@|$HOME|g; s|\011|\012|g;" 
	print $ListeOpt
} | sed '/^ *$/d' > $tmp1

commande="$Pref $NomExe < $tmp1 "${FichBlaBla:+" > $FichBlaBla 2>&1"}" &"
f_info "COMMANDE : "$commande

if (( Lance == 1 )); then
	[[ -f _STOP_ ]] && rm _STOP_
	eval $commande
	pid_sim=$!
	f_info "SIMULATION EN COURS (pid $pid_sim)"
	sleep 2
	(( NEclai==0 )) || f_Eclai &
	## f_comp &
	(( SeTaire==0 )) && [[ -f $FichBlaBla ]] && tail -f $FichBlaBla
	#wait
	#f_info "SIMULATION TERMINEE"
	#[[ -f _STOP_ ]] || touch _STOP_
else
	cat $tmp1
fi

