#!/usr/bin/zsh

# For all simulations in the working directory, extracts info from input_EvolAmas files and
# make a data base out of it 

all_columns=$(cat ~/AMAS/codes/Standard/input_EvolAmas.exple | grep '^[a-zA-Z]' | sed 's/ .*//; s/ *\#.*//' | sort -u | tr '\012' ' ')
all_columns="Name $all_columns"

list_rep=( $@ )
[[ -z $list_rep ]] && list_rep=( $(ls -1d [A-Z][A-Z]_[0-9]* | sort) )

{
    echo $all_columns
    echo $all_columns | sed 's/[^ ]/-/g'
} | tr ' ' '\011'

for rep in $list_rep; do
	if [[ ! -d $rep ]]; then
	    print -u2 "!!! Directory $rep does not exist !!!"
	else
	    input_file=$rep/input_EvolAmas
	if [[ ! -f $input_file ]]; then
	    print -u2 "!!! File $input_file does not exist !!!"
	else
	    cat $input_file | gawk -v Name=$rep '
	    BEGIN{ 
		values["Name"]=Name
	    }
	    /^[a-zA-Z]/ {
		field=$1; getline; value=$1; 
		sub("d","e",value); sub("D","e",value); 
		values[field]=value
	    } 
	    END{
		for ( field in values ) {
		    printf "%s ", field
		}
		printf "\n"
		for ( field in values ) {
		    printf "-- ", field
		}
		printf "\n"
		for ( field in values ) {
		    printf "%s ", values[field]
		}
		printf "\n"
	    }' | sed 's/ $//' | tr ' ' '\011' | column_rdb $(echo $all_columns) | tail -n1
	fi
    fi
done