#! /bin/zsh -f
cd ~/AMAS/evols/resultats
#host=$1
#shift

#source_directory=AMAS/evols/simuls
source_host="crux.ari.uni-heidelberg.de"
source_directory=disks/Crux1/AMAS/evols/simuls

# traitement des options sur la ligne de commande
while [[ $1 = -* ]]; do
    case $1 in
        -t | -T | --Terminee) source_directory=disks/Eri1/AMAS/evols/simuls/terminees ; shift 1 ;; 
	-r )    Remote=1 # force remote (out-of-ARI) transfer
		shift 1         ;;
	-l )    Local=1 # force local (ARI) transfer
		shift 1         ;;
        *  )
              print -u2 "!!! option $1 illegale !!!"
              exit 1 ;;
    esac
done            

Liste=( $@ )

ssh="ssh"
domainname=$(hostname --long)
domainname=${domainname#*.}
[[ -z $domainname ]] && domainname="somewhere.else"

if [[ -z $Remote ]] && [[ "$domainname" == "crux.uni-heidelberg.de" ]] || [[ -n $Local ]]; then
    echo "> Direct transfer to $target_host"
    ssh="ssh"
else
    echo "> Using ARI gateway computer"
    ssh="ssh -F /home/freitag/.ssh/ssh_config"
fi


rsync -auvzL --progress --rsh="$ssh" --exclude "_out" --exclude "_RIP*" --exclude "fort.*" --exclude "*.xdr"  --exclude "*.xdr.gz" --exclude "evolamas" --exclude "Grille_ResColl_SPH.asc" --exclude  "_EvolAmas%%StrongEncounters.asc" --exclude "*.BAK" --exclude "*GRILLE*" --exclude "*Tcarac.asc*" --exclude "*%?*%*" freitag@$source_host:$source_directory/RA_\* ~/AMAS/evols/resultats/
