#!/usr/bin/zsh

# Enleve la moitie des sauvegardes dans un repertoire d'evolution d'amas
# garde tjs la premiere et la derniere sauvegarde

preserve_first_n=0

while [[ $1 = -* ]]; do
    case $1 in
        -p ) preserve_first_n=$2 ; shift 2 ;;
        -t ) test=1 ; shift 1 ;; # Just print the name of the filse that would be deleted
        *  )
              print -u2 "!!! option $1 illegale !!!"
              exit 1 ;;
    esac
done

Nb=$(ls *AMAS* | wc -w | sed 's/ //g')

echo "Suppression des fichiers:"
[[ -n $test ]] && echo "--- DRY RUN ---"

for base in $(ls -1 *AMAS.xdr(|.gz|.bz2) | sort | gawk -v skip=$preserve_first_n 'NR>=skip {if(i==1){sub(/AMAS\.xdr.*/,"",$1);print $1;i=0}else{i=1}}'); do
    if [[ -z $test ]]; then
	print -u2 $base*
	rm $base*
    else
	echo $base*
    fi
done
