#!/usr/bin/ksh 

# "eclaircit" les sauvegardes d'evolution d'amas du repertoire $1 en en gardant
# qu'une sur $2. Le premier et le dernier enregistrement sont conserves.
# si $2 n'est pas precise, seul le premier et le dernier enregistrements sont
# gardes.
# Une option prealable -I InputFile indique le nom du fichier de parametres
# on prend le premier fichier *input* par defaut.
# Une option prealable -S NomBaseSauve indique le nom de base des sauvegardes
# on prend ce qui est indique dans InputFile par defaut. 

# variables globales
FichListeSauv="@LISTE_SAUV@"
FichListeGard="@LISTE_GARD@"

# fichiers provisoires
tmp1=_tmp1_$$
tmp2=_tmp2_$$

# traitement des options sur la ligne de commande
while [[ $1 = -* ]]; do
    case $1 in
	-I ) InputFile=$2 ;   shift 2 ;;
	-S ) NomBaseSauv=$2 ; shift 2 ;;
	*  )
	      print -u2 "!!! option $1 illegale !!!"
	      exit 1 ;;
    esac
done
	      
NomRep=$1
NGarde=${2:-"10000"}
RepDepart=$(pwd)

cd $NomRep

# on determine le nom de base des sauvegardes
if [[ -z $NomBaseSauv ]]; then
    if [[ -z $InputFile ]]; then
	InputFile=$( ls -1 *input* | head -n1 )
	[[ -z $InputFile ]] && {
	    print -u2 "!!! impossible de determiner le nom de base !!!"
	    exit 1
	}
    fi
    [[ -f $InputFile ]] || {
	print -u2 "!!! impossible de determiner le nom de base !!!"
	exit 1
    }
    NomSauvBase=$(
	gawk '/^NomSimul[^a-zA-Z0-9_]/ {getline;print $1}' < $InputFile | sed 's/#.*$//'
    )
fi

# liste des fichiers de sauvegarde present
ls -1 $NomSauvBase"%"* | grep '[0-9][0-9]*' | cut -d'%' -f1,2 | sort -u > $tmp1

# liste de toutes les sauvegardes realisees
[[ -f $FichListeSauv ]] || touch $FichListeSauv
cp $FichListeSauv $FichListeSauv".BAK"
cat $FichListeSauv".BAK" $tmp1 | sort -u > $FichListeSauv

# on passe en revue la liste des sauvegardes pour determiner lesquelles on garde
{
    cat $FichListeSauv | gawk -v N=$NGarde 'i++==0 {print} i==N {i=0}'
    tail -n2 < $tmp1 # par prudence, on garde aussi les 2 dernieres sauvegardes
} | sort -u > $FichListeGard

cat $FichListeGard $tmp1 | sort | uniq -d > $tmp2 # fichiers a ne pas effacer

# on fait la liste des fichiers a detruire
ListeFichEfface=$(
    cat $tmp1 $tmp2 | sort | uniq -u | awk '{print $1"%*"}'
)

# effacement des fichiers
[[ -z $ListeFichEfface ]] || rm $ListeFichEfface

# on fait le menage avant de partir
rm $tmp1 $tmp2
cd $RepDepart
