#!/bin/zsh

# Make a copy of all files useful for a "EvolAmas" simulation 
# from an existing simulation directory $1 to a nes one $2

SourceDir=$1
TargetDir=$2

[[ -d $TargetDir ]] && {
    print -u2 "!!! Target directotry $TargetDir already exists !!!"
    exit 1
}

[[ -d $SourceDir ]] || {
    print -u2 "!!! Source directotry $SourceDir doesn't exist !!!"
    exit 1
}

mkdir $TargetDir || {
    print -u2 "!!! Cannot create directotry $TargetDir !!!"
    exit 1
}

cd $SourceDir

Files=(
 input_EvolAmas \
 gere_evolamas.pl \
 evolamas \
 InitStruct_* \
 _EvolAmas%0000000000%TN.xdr \
 _EvolAmas%0000000000%ETOILES.xdr \
 _EvolAmas%0000000000%AMAS.xdr \
 *Mbins.asc \
 *FracSegrLag.asc \
 *FracSTSLag.asc \
 *FracRayLag.asc \
 ParamStellEvol.asc \
 MassRadiusMS.asc \
 NonInterac.asc \
 Grille_ResColl_SPH.asc
)
cd -

for File in $Files; do
    cp -v $SourceDir/$File(|.gz|.bz2) $TargetDir/
done
