#!/bin/zsh

eta_list=2
mu_list=0.1
Np_list=64000
q_list=10
f_list=0.05
Rmin=0.0
stuff=''

while [[ $1 = -* ]]; do
    case $1 in
	-Rmin ) Rmin=$2; shift 2 ;;
	-eta ) eta_list=( $(echo $2) ); shift 2 ;;
	-mu  ) mu_list=(  $(echo $2) ); shift 2 ;;
	-Np  ) Np_list=(  $(echo $2) ); shift 2 ;;
	-q   ) q_list=(   $(echo $2) ); shift 2 ;;
	-f   ) f_list=(   $(echo $2) ); shift 2 ;;
        -s   ) stuff=$2; shift 2 ;;
        *    )
              print -u2 "!!! option $1 illegale !!!"
              exit 1 ;;
    esac
done

cd ~/AMAS/Modeles

for eta in $eta_list; do
    for mu in $mu_list; do
	for Np in $Np_list; do
	    for q in $q_list; do
		for f in $f_list; do
		    Base_Name=eta$(formatter_nombre.sh $eta)mu$(formatter_nombre.sh $mu)$stuff
		    File_1Comp=$Base_Name"_"$(formatter_milliers.sh $Np).xdr
		    File_2Comp=$Base_Name"_2comp_q"$(formatter_nombre.sh $q)"f"$(formatter_nombre.sh $f)_$(formatter_milliers.sh $Np).xdr
		    File_Nbody=${File_2Comp%.xdr}.nbody.asc.gz

		    { [[ -f $File_1Comp ]] || creer_amas_eta_tn -eta $eta -mu $mu -N $Np -Name $File_1Comp -Rmin $Rmin } && \
		    checkamas $File_1Comp && \
		    appliquerfmdiscr -m "1,$q" -f "$(( 1 - f )),$f" -t "1,5" -method 3  $File_1Comp $File_2Comp 2> /tmp/tmp_$$ && \
		    { [[ -f ${File_2Comp%.xdr}_TN.xdr ]] || ln -s ${File_1Comp%.xdr}_TN.xdr ${File_2Comp%.xdr}_TN.xdr } && \
		    checkamas $File_2Comp && \
		    Amas_XDR2NCadavre -NonVirialized -mu $mu -Mstar_avrg $(
			cat /tmp/tmp_$$ | grep 'Masse moyenne' | head -n1 | sed 's/.*: *//'; rm /tmp/tmp_$$
		    ) -StellRad -shift_center 1e-3 $File_2Comp | gzip --to-stdout > $File_Nbody 
		done
	    done
	done
    done
done
