#! /bin/zsh -f

# applique une IMF 'top-heavy' 'minimale' consistante avec les obs. de Figer et al. (99, ApJ 525, 750)
# avec age $2 (en yrs)
# au fichier d'amas $1 pour en faire $1_TH
# La partie low-mass (M<0.5) de l'IMF est compatible avec Kroupa (2000, 2002)

exec=appliquerfm3
suff=""

if [[ $1 == '-f' ]]; then
    fancy_remn=1
    exec=appliquerfm3_fancy_remn
    shift 1
fi

FichIn=$1
Age=${2:-"0"}
Tsf=${3:-"0"}

test.sh "$Age > 0" && suff=$suff"_evol"
[[ -n $fancy_remn ]] && suff=$suff"_frmn"
test.sh "$Tsf > 0" && suff=$suff"_xsf"
FichOut=${FichIn%".xdr"}"_TH"$suff".xdr"
FichLog=${FichIn%".xdr"}"_TH"$suff".log"

print -u2  $FichIn "--> "$FichOut

$exec -age $Age -Tsf $Tsf -m "0.01,0.08,0.5,8,120" -a "0.3,1.3,2.3,1.65" $FichIn $FichOut 2>&1 | tee $FichLog
