#! /bin/zsh -f

# applique une IMF de type Kroupa (2000) avec age $2 (en yrs)
# au fichier d'amas $1 pour en faire $1_K00
# Version 'bottom poor' en vue de minimiser la contribution des etoiles de (tres) faible masse

exec=appliquerfm3
suff=""

if [[ $1 == '-f' ]]; then
    fancy_remn=1
    exec=appliquerfm3_fancy_remn
    shift 1
fi


FichIn=$1
Age=${2:-"0"}
Tsf=${3:-"0"}

test.sh "$Age > 0" && suff=$suff"_evol"
[[ -n $fancy_remn ]] && suff=$suff"_frmn"
test.sh "$Tsf > 0" && suff=$suff"_xsf"
FichOut=${FichIn%".xdr"}"_K00_BP"$suff".xdr"
FichLog=${FichIn%".xdr"}"_K00_BP"$suff".log"

print -u2  $FichIn "--> "$FichOut

$exec -age $Age -Tsf $Tsf -m "0.01,0.08,0.5,120" -a "-0.4,0.8,2.3" $FichIn $FichOut 2>&1 | tee $FichLog
