#! /bin/zsh -f

# Mass functions for core collapse comparisons for Modest-6

command="$0 $@"

exec=appliquerfm3

iseed=56317
iModel=0

gamma=0.02

# traitement des options sur la ligne de commande
while [[ $1 = -* ]]; do
    case $1 in
        -model|-m ) iModel=$2 ; shift 2 ;;
        -iseed ) iseed=$2 ; shift 2 ;;
        *  )
              print -u2 "!!! option $1 illegale !!!"
              exit 1 ;;
    esac
done

FichIn=$1

case $iModel in
    1 ) Mmin=1; Mmax=1; alpha=0; single_mass=1;;
    2 ) Mmin=0.2; Mmax=1; alpha=2.35;;
    3 ) Mmin=0.2; Mmax=10; alpha=2.35;;
    4 ) Mmin=0.2; Mmax=120; alpha=2.35;;
    5 ) Mmin=0.2; Mmax=120; alpha=1.5;;
    * )
	print -u2 "!!! invald model number !!!"
	exit 2 ;;
esac

BaseName=${FichIn%".xdr"}"_CC05-"$iModel
FichOut=$BaseName".xdr"
FichLog=$BaseName".log"

print -u2  $FichIn "--> "$FichOut

if [[ -n $single_mass ]]; then
    ln -s $FichIn $FichOut
    gamma=0.11
    AvrgStellMass=1
else
    $exec -iseed $iseed -m "$Mmin,$Mmax" -a $alpha $FichIn $FichOut 2>&1 | tee $FichLog

    AvrgStellMass=$(cat $FichLog | grep 'Masse moyenne' | head -n 1 | sed 's/.*: *//')
    [[ -z $AvrgStellMass ]] && {
	print -u2 '!!! $0: cannot determine average stellar mass !!!'
	exit 1
    }

fi

[[ -f $BaseName"_ETOILES.xdr" ]] && rm $BaseName"_ETOILES.xdr"

# Write relevant info into *_input_EvolAmas file

old_input_file=${FichIn%".xdr"}"_input_EvolAmas"
new_input_file=$BaseName"_input_EvolAmas"

[[ -f $new_input_file ]] && rm $new_input_file
[[ -f $old_input_file ]] && cat $old_input_file > $new_input_file

cat <<EOF >>$new_input_file
# Model for Modest-6 core collapse comparison (model $iModel)
# Mmin=$Mmin; Mmax=$Mmax; alpha=$alpha
# Parameters written by command "$command"

Gamma_relax          # Coef in Coulomb log
    $gamma   # 0.11 for single-mass, 0.02 for multi-mass

MasseEtoileDef       # Average stellar mass in Msun
    $AvrgStellMass  # Valeur par defaut : 1.0d0

rNbEtoiles           # Nb (initial) total detoiles
    $(nbse.sh $FichOut)    # 1 part = 1 star

Frac_Trelax          # max dt / tps relax
    0.025d0   # Valeur par defaut : 0.01d0

FactTrelMax          # Rapport max entre Trel et le Trel_min (pour pas de tps)
    1.0d6   # Valeur par defaut : 1.0d3

FacNbPasSauvPart     # Facteur determinant le nb de pas entre deux sauvegardes partielles
    0.12d0   # Valeur par defaut : 1.0d0

FacNbPasSauv         # Facteur determinant le nb de pas entre deux sauvegardes
    1.0d0   # Valeur par defaut : 5.0d0

NbSauv_Conserve      # 1 sauvegarde (fichiers XDR) sur NbSauv_Conserve est conservee, les autres effacees au fur et a mesure
    5   # Valeur par defaut : 5

FacNbPasTestDemSauv  # Facteur determinant le nb de pas entre deux tests pour demande de sauvegarde
    0.5d0   # Valeur par defaut : 0.1d0


EOF
