#! /bin/zsh -x

# Apply a 2-component mass function to cluster (.xdr) file $1

exec=appliquerfmdiscr_1M

suff=""
iseed=5637

iT1=1 # default type for light components (MS)
iT2=5 # default type for heavy components (BH)
m1=0.7 # default mass for light component (in Msun)
m2=10  # default mass for heavy component (in Msun)
Mtot=1e6 # default total mass
fm2=0.01 # default mass fraction of heavy objects (eta)

# traitement des options sur la ligne de commande
while [[ $1 = -* ]]; do
    case $1 in
	-T1 ) iT2=$2;
	     shift 2;;
	-T2 ) iT2=$2;
	     shift 2;;
	-m1 ) m1=$2;
	     shift 2;;
	-m2 ) m2=$2;
	     shift 2;;
	-fm2 ) fm2=$2;
	     shift 2;;
	-eta ) fm2=$2;
	     shift 2;;
	-Ntot ) Ntot=$2;
	     shift 2;;
	-Mtot ) Mtot=$2;
	     shift 2;;
	-io ) input_only=1;
	     shift 1;;
        *  )
              print -u2 "!!! option $1 illegale !!!"
              exit 1 ;;
    esac
done

eta=$fm2
fm1=$(( 1.0 - fm2 ))
fN2=$(( eta*m1/(m2+eta*(m1-m2)) ))
fN1=$(( 1.0 - fN2 ))
Mav=$(( fN1*m1 + fN2*m2 ))
[[ -n $Ntot ]] && Mtot=$(( Ntot*Mav ))
M1=$(( fm1*Mtot ))
M2=$(( fm2*Mtot ))
Ntot=$(( Mtot/Mav ))
N1=$(( fN1*Ntot ))
N2=$(( fN2*Ntot ))

FichIn=$1
BaseName=${FichIn%".xdr"}"_2comp%m1:"$(formatter_nombre.sh $m1)"%m2:"$(formatter_nombre.sh $m2)"%fm2:"$(formatter_nombre.sh $fm2)
FichOut=$BaseName".xdr"
FichLog=$BaseName".log"
FichParam=$BaseName"_input_EvolAmas"

print -u2  $FichIn "--> "$FichOut

cat <<EOF | tee $FichParam | tee $FichLog
# 2-component model created $(date)
#--------------------------------------------------------------
#  m1=$m1 m2=$m2 Msun
#  M1=$M1 M2=$M2 Mtot=$Mtot Msun
#  N1=$N1 N2=$N2 Ntot=$Ntot stars
#  iT1=$iT1 iT2=$iT2 (stellar types)
#  fN1=$fN1 fN2=$fN2 (number fractions)
#  fm1=$fm1 fm2=$fm2 (mass fractions)

EOF

cat <<EOF2 >> $FichParam

Gamma_relax          # Le coefficient de proportionalite dans le log. coulombien
    0.01d0   # Valeur par defaut : 0.14d0

MasseEtoileDef       # Masse de chaque etoile en masse solaire (par defaut)
   $Mav    # Valeur par defaut : 1.0d0

rNbEtoiles           # Nb (initial) total detoiles
   $Ntot   # Valeur par defaut : 1.0d6

EOF2

[[ -n $input_only ]] && exit

$exec -m "$m1,$m2" -f "$fN1,$fN2" -t "$iT1,$iT2" $FichIn $FichOut 2>&1 | tee -a $FichLog
