#!/usr/bin/ksh

Options=""

exec=amas_xdr2rdb

# traitement des options sur la ligne de commande
while [[ $1 = -* ]]; do
        case $1 in
                -z ) Compresse=1; suffixe=$suffixe
                  shift 1 ;;
                -hp ) exec=amas_xdr2rdb_HighPrec
                  shift 1 ;;
                *  )    print -u2 "!!! option $1 incorrecte !!!"
                                exit 1  ;;
        esac
done



ListeFich="$@"
[[ -z $ListeFich ]] && ListeFich=$(ls *AMAS.xdr 2>/dev/null) 

for file in $ListeFich; do
    NomFichRDB=${file%.xdr}.rdb${Compresse+".gz"}
    if [[ -f $NomFichRDB ]]; then
	print -u2 "> file $NomFichRDB exists, skipped."
    else
	print -u2 "> creating $NomFichRDB from $file"
	$exec $file |\
	if [[ -n $Compresse ]]; then 
	    gzip --to-stdout
	else
	    cat
	fi > $NomFichRDB
    fi
done

