#!/usr/bin/zsh

num_part=$1 # parametre sur la ligne de commande du script

print "\# Particule = $num_part"
print "\# 1:T 2:Mass 3:Rx 4:Ry 5:Rz 6:Vx 7:Vy 8:Vz 9:R 10:Phi"

for file in $( ls Splotch*_part.asc(|.gz) ); do;
   print -u2 "> File $file..."
   gunzip --force --to-stdout $file | gawk -v NAME=$num_part '
         /AS/ {TIME=$4}
         $1==NAME {print TIME,$2,$3,$4,$5,$6,$7,$8,$11,$10; exit}
    '
done
