#!/usr/bin/zsh

function clean_up {
    print -u2 "... cleaning up"
    rm /tmp/$$'_'*
}

trap "clean_up" EXIT

Wo=7
Nstar=50000
#masses="0.01,0.08,0.5,50" # Kroupa
#alphas="0.3,1.3,2.3" # Kroupa
#masses="0.5,120"
#alphas="2.35"
masses="0.1,0.08,0.5,60" # Kroupa
alphas="0.3,1.3,2.3" # Kroupa
age=3e6
M_IMBH=500

model_file=_model_.nbody.asc
log_file=_model_.log.asc

echo New Run: $(date) > $log_file

creer_king -W $Wo -N $Nstar -Name /tmp/$$_tmp1 |& cat >> $log_file | cat

appliquerfm3  -m "$masses" -a "$alphas" -age $age /tmp/$$_tmp1.xdr /tmp/$$_tmp2.xdr |& cat >> $log_file | cat

Mstar_avrg=$(cat $log_file | gawk '/Masse moyenne \(Msol\)/ {print $NF; exit}')

ln -s /tmp/$$_tmp2.xdr
mu=$(( M_IMBH/(Nstar*Mstar_avrg) ))
Amas_IntroduceMBH -mu $mu $$_tmp2.xdr  |& cat >> $log_file | cat

mv _ChangedMctr_$$_tmp2_AMAS.xdr /tmp/$$_tmp1.xdr
rm _ChangedMctr_$$_tmp2_TN.xdr
mv /tmp/$$_tmp2_ETOILES.xdr /tmp/$$_tmp1_ETOILES.xdr
rm $$_tmp2.xdr

Amas_XDR2NCadavre -StellRad -NonVirialized -mu $mu -Mstar_avrg $Mstar_avrg -shift_center 1e-4 /tmp/$$_tmp1.xdr 2>> $log_file > /tmp/$$_tmp2

{
    print "### Created with the following script ($0):"
    print "###"
    cat $0 | gawk '{print "#| "$0}'
    print "###"
    cat /tmp/$$_tmp2
} > $model_file

gzip -v $model_file


print -u2
print -u2
print -u2
print -u2 \> Cluster data written in $model_file.gz
print -u2 \> operations logged in $log_file