#!/usr/bin/zsh
# Combine information from Splotch*_triax.asc[.gz] file into sequential files indicating evolution
# of triaxiality; one file per mass fraction

function clean_up {
    print -u2 "... cleaning up"
    rm /tmp/$$'_'*
}

trap "clean_up" EXIT


[[ -f NT_Splotchs.asc ]] || [[ -f NT_Splotchs.asc.gz ]] || {
    print u2 "!!! File NT_Splotchs.asc[.gz] not found. So long, looser !!!"
    exit 1
}

Files=( $(ls Splotch*_triax.asc(|.gz) | sort) )
gunzip --to-stdout --force NT_Splotchs.asc(|.gz) | grep -v '^#' > /tmp/$$_NT

# Get mass fractions
Fracs=( $(gunzip --to-stdout --force $Files[0] | gawk '/^[^#]/ {printf "%5.3f\n", $1 }' ) )

# Form header
print "# Evolution of triaxiality (inertia ellipsoid)" > /tmp/$$_hdr
{
    echo step\\ntime
    gunzip --to-stdout --force $Files[0] | grep '^#' | tail -n 1 | sed 's/^#//; s/ *[0-9][0-9]* *: */ /g; s/^  *//; s/  *$//' | tr ' ' '\012'
} | gawk '{print ++i":"$1}' | tr '\012' ' ' | sed 's/^/# /' >>  /tmp/$$_hdr
echo >> /tmp/$$_hdr


for file in $Files; do
    gunzip --to-stdout --force $file | grep -v '^#' > /tmp/$$_data
    step=${file%_triax.asc*}
    step=${step##*_}
    step=$(( step + 0 ))
    time=$(cat /tmp/$$_NT | gawk -v step=$step '$1==step {print $2}')
    for frac in $Fracs; do
	print -u2 " Extracting info for mass fraction $frac from $file (step $step)..."
	file_evol=EvolTriax_$(echo $frac | sed 's/\./p/').asc
	[[ -f $file_evol ]] || cp  /tmp/$$_hdr $file_evol
	print -u2 "File $file_evol"
	cat /tmp/$$_data | gawk -v frac=$frac -v step=$step -v time=$time '$1==frac {print step,time,$0}' >> $file_evol
    done
done

