XXXXXXXXX
#!/usr/bin/zsh
# Combine information from Splotch*_LagrRad.asc[.gz] files into one sequential file indicating evolution
# of Lagrangian quantities

function clean_up {
    print -u2 "... cleaning up"
    rm /tmp/$$'_'*
}

trap "clean_up" EXIT


[[ -f NT_Splotchs.asc ]] || [[ -f NT_Splotchs.asc.gz ]] || {
    print u2 "!!! File NT_Splotchs.asc[.gz] not found. So long, looser !!!"
    exit 1
}

# There might be different series of *_lagr_* files, for different reference particle or particle sets
# For instance, in the case of a merger, one can have series relative to each cluster's central particle
# and one series relative to the center of the merged cluster

gunzip --to-stdout --force NT_Splotchs.asc(|.gz) | grep -v '^#' > /tmp/$$_NT

Files=( $(ls Splotch*_LagrRad.asc(|.gz) | sort) )
    
#   Get mass fractions
Fracs=( $(gunzip --to-stdout --force $Files[0] | gawk '/^[^#]/ {printf "%6.5f\n", $1 }' ) )

gunzip --to-stdout --force $Files[0] | grep -v '^#' | tail -n 1

for file in $Files; do
    gunzip --to-stdout --force $file | grep -v '^#' | tail -n 1 | 
    gunzip --to-stdout --force $file | grep -v '^#'

	step=$(( ${${file%_lagr*}##*_} ))
        time=$(cat /tmp/$$_NT | gawk -v step=$step '$1==step {print $2}')
	echo $step" "$time$(gunzip --to-stdout --force $file | grep '^# .*_ref  *=' | cut -d '=' -f 2 | tr '\012' ' ' | sed 's/  */ /g') >> $ref_file
	for frac in $Fracs; do
	    print -u2 " Extracting info for mass fraction $frac from $file (step $step)..."
	    file_evol=EvolLagr_ref$ref""_$(echo $frac | sed 's/\./p/').asc
	    [[ -f $file_evol ]] || cp  /tmp/$$_hdr $file_evol
	    print -u2 "File $file_evol"
	    cat /tmp/$$_data | gawk -v frac=$frac -v step=$step -v time=$time '$1==frac {print step,time,$0}' >> $file_evol
	done
    done
done

