#!/bin/zsh


ListeFich=( $@ )

[[ -z $ListeFich ]] && ListeFich=( $(ls Splotch4_[0-9][0-9][0-9][0-9]_part.asc* 2>/dev/null) )

for file in $ListeFich; do
    LagrFile=${file%%_part*}_LagrRad.asc
    if [[ -f $LagrFile ]] || [[ -f $LagrFile.gz ]]; then
	print -u2 $LagrFile"(.gz) exist, skipped"
    else
	print -u2 '> '$file' --> '$LagrFile
	gunzip --to-stdout --force $file | grep -v '#' | sort -n -k 1 |\
	    gawk '{print $2,$3,$4,$5,$6,$7,$8}' |\
	    Nbody2Lagr -frac "0.01 0.03 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.95 0.99" -ref "1 2" > $LagrFile
    fi
done
