#!/usr/bin/ksh

# Nom : MAJ_Param_EvolAmas.sh
# ##################################

# BUT        : 	a partir d'un fichier /rdb decrivant les parametres
# ===========  	de simulation pour EvolAmas.F en entree std (EvolAmas_Param.rdb),
#               cree les fichiers fortran (EvolAmas_Param_common.f, EvolAmas_ParamIO.F)
#               et un fichier d'input (input_EvolAmas.exple) correspondant
		
# Appele par : 	
# -----------	

# Appelle    :	EvolAmas_Param_rdb2common.sh 
# -----------	EvolAmas_Param_rdb2IO.sh
#               EvolAmas_Param_rdb2input.sh

# fonction appelee a la sortie du script

function f_Sortie {
        rm 'tmp'?'_'$NomScript'_'$PIDScript'_tmp'?
        print -u2 $ligne_hier"====< script $NomScript termine"
}

export ligne_hier=$ligne_hier"= "
NomScript=${0##*/}
PIDScript=$$
print -u2 $ligne_hier"====> script $NomScript"
trap  "f_Sortie" EXIT

# fichiers provisoires

tmp1=tmp1'_'$NomScript'_'$PIDScript'_'tmp1
touch $tmp1
#......................................................................

NomFichCommon='EvolAmas_Param_common.f'
NomFichIO='EvolAmas_ParamIO.F'
NomFichInput='input_EvolAmas.exple'

cat > $tmp1

[[ ! -f $NomFichCommon ]] || mv $NomFichCommon $NomFichCommon".BAK"
EvolAmas_Param_rdb2common.sh < $tmp1 > $NomFichCommon && {
    print -u2 "> fichier $NomFichCommon cree" 
} || {
    print -u2 "!!! erreur a la creation du fichier $NomFichCommon !!!"
    exit 1
}

[[ ! -f $NomFichIO ]] || mv $NomFichIO $NomFichIO".BAK"
EvolAmas_Param_rdb2IO.sh < $tmp1 > $NomFichIO && {
    print -u2 "> fichier $NomFichIO cree" 
} || {
    print -u2 "!!! erreur a la creation du fichier $NomFichIO !!!"
    exit 2
}

[[ ! -f $NomFichInput ]] || mv $NomFichInput $NomFichInput".BAK"
EvolAmas_Param_rdb2input.sh < $tmp1 > $NomFichInput && {
    print -u2 "> fichier $NomFichInput cree" 
} || {
    print -u2 "!!! erreur a la creation du fichier $NomFichInput !!!"
    exit 3
}

