#!/usr/bin/zsh

# This script reads a file of type *%%COLL.asc in std in and spits out
# to std out an /rdb file in wich each collision is represented by two
# lines, one for each star

# Replaces the crapy FichColl_doubler_lignes_*.sh scripts. Doesn't
# depend on the names and number of columns in input file

tmp1=/tmp/tmp1_$$
tmp2=/tmp/tmp2_$$

fort2rdb.sh > $tmp1

header_orig=$(head -n1 < $tmp1 | tr '\011' ' ')
header_1=( $(echo $header_orig | sed 's/1$//; s/1 / /g; s/2$/_prtn/; s/2 /_prtn /g') )
header_2=( $(echo $header_orig | sed 's/2$//; s/2 / /g; s/1$/_prtn/; s/1 /_prtn /g') )

#echo $header_1
#echo $header_2
#exit

{
    {
	echo $header_1 | tr ' ' '\011'
	cat $tmp1 | gawk 'i++>0 {print}'
    }
    {
	echo $header_2 | tr ' ' '\011'
	cat $tmp1 | gawk 'i++>0 {print}'
    } | column_rdb  $header_1 | headoff
} | sorttable -n iPas_evol -n iSE



[[ -f $tmp1 ]] && rm $tmp1