#!/usr/bin/env zsh
# Try and convert the "distribution" output data from the FP code by H M Lee
# Into a flat multicolumn format

function clean_up {
    print -u2 "... cleaning up"
    rm /tmp/$$'_'*
}

cat > /tmp/$$_IN

nComp=$(gawk '/step/{exit} END{print NR-3}' < /tmp/$$_IN)
(( nComp>1 )) && nComp_eff=$(( nComp+1 )) || nComp_eff=1

typeset -Z 2 iComp_
for (( iComp=1; iComp<=nComp_eff; iComp++ )); do
    if (( iComp <= nComp )); then
	iComp_=$iComp
	outfile=GlobData_Comp$iComp_.asc
    else
	outfile=GlobData_Glob.asc
    fi
    print -u2 "> creating file $outfile"
    print "# Global data for FP simulation ($0)" > $outfile
    if (( iComp < nComp )); then
	print "# Component : $iComp" >> $outfile
    else
	print "# Component : global" >> $outfile
    fi
    print "# istep time rh x0 rho0 vm02 gamm rcore tr0 xi" >> $outfile
    gawk '
        /^step .* t = / {istep=$2; time=$5; rh=$NF} 
        /^\( *'$iComp'\)/ { 
           x0=$(NF-6); rho0=$(NF-5); vm02=$(NF-4); gamm=$(NF-3); rcore=$(NF-2); tr0=$(NF-1); xi=$NF;
           printf "%4i %17.10e %12.5e  %12.5e %12.5e %12.5e %12.5e %12.5e %12.5e %12.5e\n", istep,time,rh,x0,rho0,vm02,gamm,rcore,tr0,xi 
       }
    ' < /tmp/$$_IN >> $outfile
done
