#!/usr/bin/ksh

# Nom : EvolAmas_Param_rdb2common.sh
# ##################################

# BUT        : 	a partir d'un fichier /rdb decrivant les parametres
# ===========  	de simulation pour EvolAmas.F en entree std (EvolAmas_Param.rdb),
#               fait un fichier de commons correspondant en sortie std 
#               (EvolAmas_Param_common.f)
		
# Appele par : 	
# -----------	

# Appelle    :	
# -----------	

# fonction appelee a la sortie du script

function f_Sortie {
        rm 'tmp'?'_'$NomScript'_'$PIDScript'_tmp'?
        print -u2 $ligne_hier"====< script $NomScript termine"
}

export ligne_hier=$ligne_hier"= "
NomScript=${0##*/}
PIDScript=$$
print -u2 $ligne_hier"====> script $NomScript"
trap  "f_Sortie" EXIT

# fichiers provisoires

tmp1=tmp1'_'$NomScript'_'$PIDScript'_'tmp1
tmp2=tmp2'_'$NomScript'_'$PIDScript'_'tmp2
touch $tmp1 $tmp2
#......................................................................

cat <<EOF
c======================================================================
c    Blocs common des parametres de simulation pour EvolAmas.F
c    fichier genere automatiquement par $NomScript
c======================================================================
EOF

cat | compute 'if(Type=="double precision") Type="dp@"' > $tmp1
for type in $(column_rdb Type < $tmp1 | headoff | sort -u); do
    print
    print "      $type"
    row 'Type=="'$type'"' < $tmp1 | column_rdb NomVar Explication | headoff > $tmp2
    NbElem=$(wc -l < $tmp2)
    cat $tmp2 | gawk -v NE="$NbElem" '
	BEGIN{FS="\t"} 
	{
	    printf("     &    %s",$1)
	    blancs="";
	    for(j=0;j<20-length($1);j++) { blancs=blancs " " };
	    if (++i==NE) { printf(" ") } else { printf(",") }
	    printf("%s !  %s\n",blancs,$2)
    }'
    print
    print "      common /Common_Param_$type/" |\
    sed '
	s/dp\@/dp/; 
	s/\*//;
	s/character/char/;
	s/integer/int/
    '
    cat $tmp2 | gawk '{
	liste2 = liste $1 ", ";
	if (length(liste2)>65) { 
	    printf("     &    %s\n",liste); liste=$1", ";
	} else {
	    liste = liste2
	}
    } END{sub(", *$","",liste);printf("     &    %s\n",liste)}'
done |\
sed 's/dp@/double precision/'
