#!/usr/bin/ksh

# Nom : EvolAmas_Param_rdb2IO.sh
# ##################################

# BUT        : 	a partir d'un fichier /rdb decrivant les parametres
# ===========  	de simulation pour EvolAmas.F en entree std (EvolAmas_Param.rdb),
#               fait les routines fortran d'entree-sortie de ces parametres
#               (EvolAmas_Param_common.f)
		
# Appele par : 	
# -----------	

# Appelle    :	
# -----------	

# fonction appelee a la sortie du script

function f_Sortie {
        rm 'tmp'?'_'$NomScript'_'$PIDScript'_tmp'?
        print -u2 $ligne_hier"====< script $NomScript termine"
}

export ligne_hier=$ligne_hier"= "
NomScript=${0##*/}
PIDScript=$$
print -u2 $ligne_hier"====> script $NomScript"
trap  "f_Sortie" EXIT

# fichiers provisoires

tmp1=tmp1'_'$NomScript'_'$PIDScript'_'tmp1
tmp2=tmp2'_'$NomScript'_'$PIDScript'_'tmp2
touch $tmp1 $tmp2
#......................................................................
cat | sorttable Type | compute 'if(Type=="double precision") Type="dp@"' > $tmp1

# en-tete du fichier fortran
cat <<EOF
c======================================================================
c     Routines d'entrees/sorties des parametres de simulation
c     pour EvolAmas.F
c     code genere automatiquement par $0
c======================================================================
c
EOF

#
# ROUTINE DE LECTURE DES PARAMETRES
# =================================

cat <<EOF
c----------------------------------------------------------------------
      subroutine Lire_Fich_Param_EvolAmas(NumFich)
c----------------------------------------------------------------------
c     Lit les donnees necessaire a l'execution de programme 
c     d'evolution d'amas. Le fichier doit etre sous le format :
c
c      1ere colonne
c     / 
c     NomAmasIn        << Nom de la variable
c       Amas_in.dat    << valeur 
c
c     NbPas             
c       100
c     ....
c
      include 'EvolAmas_param.f'
      include 'EvolAmas_Param_common.f' ! blocs common contenant les
                                        ! parametres
c
      integer NumFich
      character*80 Ligne
      character*1 car
c......................................................................
EOF
# valeurs par defaut des variables
cat <<EOF
c
c---- Valeurs par defaut des parametres de simulation
c
EOF
cat $tmp1 | column_rdb NomVar ValDefaut | headoff | gawk '{
    printf("      %-20s = %s\n",$1,$2)
}'

# lecture du fichier de configuration
cat <<EOF
c
c---- Lecture du fichier de parametres
c
 1    continue
      read(NumFich,'(A)',END=2) Ligne
      call EnleverBlancs(Ligne)
c
c---- on saute les lignes blanches et les commentaires
c
      if (LEN(Ligne).EQ.0 .OR. Ligne(1:1).EQ.'#') then
	 goto 1
c
c---- on lit les parametres presents
c
EOF
cat $tmp1 | column_rdb NomVar Type | headoff | gawk '{
    chaine = $1 "'\'')"
    printf("      else if (Ligne.EQ.'\''%-20s then\n",chaine);
    if($2~"character") {
	printf("         read(NumFich,'\''(A)'\'') %s\n",$1);
	printf("         call EnleverBlancs(%s)\n",$1);
    } else {
	if($2~"integer") {
	    print  "#if (_COMPIL_==3)"
	    printf("         read(NumFich,'\''(I)'\'') %s\n",$1);
	    print  "#else"
	    printf("         read(NumFich,*) %s\n",$1);
	    print  "#endif"
	} else {
	    printf("         read(NumFich,*) %s\n",$1);
	}
    };
    print "";
}'
# fin de la routine de lecture
cat <<EOF
         
      else
         write(0,100) Ligne 
 100     format(/,'!!! Le parametre ',A20,' n''a pas de sens !!!')
         read(NumFich,'(A)') car ! on saute une ligne
         call exit(1)
         
      end if
      goto 1

 2    continue
c
      end
c
EOF

#
# ROUTINE D'ECRITURE DES PARAMETRES
# =================================

# en-tete :
cat <<EOF
c----------------------------------------------------------------------
      subroutine Ecrire_Fich_Param_EvolAmas(NumFich)
c----------------------------------------------------------------------
c     Ecrit les donnees necessaire a l'execution de programme 
c     d'evolution d'amas.
c
      include 'EvolAmas_param.f'
      include 'EvolAmas_Param_common.f' ! blocs common contenant les
                                        ! parametres
      integer NumFich
c......................................................................  
c   
EOF

#
cat <<EOF
      write(NumFich,1000)
 1000 format(
     $     '# --------------------------',/,
     $     '# Parametres pour EvolAmas.f',/,
     $     '# --------------------------',/,
     $     /)
EOF

cat $tmp1 | column_rdb NomVar Type | headoff | gawk 'BEGIN{form_line=1000}{
    if ($2~"character") {format="A"};
    if ($2~"dp") {format="E12.4"};
    if ($2~"real") {format="E12.4"};
    if ($2~"integer") {format="I10"};
    if ($2~"logical") {format="L"};
    form_line++
    print "      write(NumFich,"form_line") "$1
    printf(" %4d format('\''%-20s'\'',/,'\''  '\'',%-5s)\n",form_line,$1,format);
}
END{}'
# fin de la routine
cat <<EOF
      write(NumFich,2000)
 2000 format(
     $     /,
     $     '# --------------------------')
c
      end
c
EOF

# valeurs par defaut des variables definies dans block data
cat <<EOF
c----------------------------------------------------------------------
c---- Valeurs par defaut des parametres de simulation
c----------------------------------------------------------------------
      block data BD_Init_Param
c----------------------------------------------------------------------
      include 'EvolAmas_param.f'
      include 'EvolAmas_Param_common.f'

EOF
cat $tmp1 | column_rdb NomVar ValDefaut | headoff | gawk '{
    printf("      data %-20s /%-12s/\n",$1,$2)
}'
cat <<EOF
c
      end
c----------------------------------------------------------------------
EOF
