#!/usr/bin/env zsh

cat > /tmp/$$_TMP

Mtot=$(cat  /tmp/$$_TMP | gawk 'BEGIN{eps_EarMark=1e-13} 
     /^#/ {next}
     {
       ++i; 
       if (i==1){
         Mtot=$1
       } else {
          Mtot=Mtot+$1*(1+i*eps_EarMark)
       }
     }
     END{printf "%21.15e\n", Mtot; printf "Mtot=%21.15e\n", Mtot > "/dev/stderr"}
')


cat  /tmp/$$_TMP | gawk -v Norm=$Mtot 'BEGIN{eps_EarMark=1e-13} 
     /^#/ {line=$0; print; next}
     {
       ++i; 
       if (i==1){
          print "#" 
          print "# Masses Earmarked with '$0'"
          print line
          $1=$1/Norm
         Mtot=$1
       } else {
          $1=$1*(1+i*eps_EarMark)/Norm
          Mtot=Mtot+$1
       }
       printf "%21.15e %21.15e %21.15e %21.15e %21.15e %21.15e %21.15e %12.5e\n", $1,$2,$3,$4,$5,$6,$7,$8 
     }
     END{printf "Mtot=%21.15e\n", Mtot > "/dev/stderr"
}
'

rm  /tmp/$$_TMP