#!/usr/bin/zsh

n_freq=1
execbasename=Amas_SelectStellMassSlice

while [[ $1 = -* ]]; do
    case $1 in
	-n      ) n_freq=$2  ; shift 2 ;; # only consider 1 file over $n_freq
	-x      ) execbasename=$2  ; shift 2 ;;
	-prefix ) prefix=$2  ; shift 2 ;;
        *       )
              print -u2 "!!! option $1 illegale !!!"
              exit 1 ;;
    esac
done

Mmin=$1
Mmax=$2
shift 2
file_list=( $@ )
 
[[ -n $3 ]] && this_file=$3

[[ -z $Mmin ]] && {
    print -u2 "!!! Don't know what the min mass is... So long !!!"
    exit 1
}
[[ -z $Mmax ]] && {
    print -u2 "!!! Don't know what the max mass is... Have fun playing Packman !!!"
    exit 1
}

Mavrg=$(cat input_EvolAmas | grep -A1 'MasseEtoileDef' | tail -n1 | sed 's/^ *//; s/ *#.*//')

[[ -z $Mavrg ]] && {
    print -u2 "!!! Cannot determine the average mass from input_EvolAmas, so I piss off !!!"
    exit 1
}
print -u2 

executable=./$execbasename
[[ -x $executable ]] || executable=~/AMAS/util/$execbasename
[[ -x $executable ]] || executable=~/backup_laptop/AMAS/util/$execbasename
[[ -x $executable ]] || {
    print -u2 "!!! Cannot find executable (SelectStellMassSlice)... Verrrrry funny, indeed !!!"
    exit 1
}

print -u2 "> using $executable with Mmin=$Mmin, Mmax=$Mmax and Mavrg=$Mavrg"

function deal_with_file {
    $executable $file $Mavrg $Mmin $Mmax
    newfile=
    [[ -n $prefix ]] && {
	mv StellMassSlice_$file $prefix"_"$file
	newfile=$prefix"_"$file
    } || {
	newfile=StellMassSlice_$file
    }
    num=${file%""%*}
    num=${num#*%}
    num=$(( num +  0 ))
    print -u2 "> step_number: $num inputfile: $file outputfile: $newfile"
    last_file=$file
}

[[ -z $file_list ]] && file_list=( $(ls _EvolAmas%*%AMAS.xdr) )
i=0
for file in $file_list; do
    (( i == 0 )) && deal_with_file
    i=$(( i + 1 ))
    (( i == n_freq )) && i=0
done

[[ $file != $last_file ]] && deal_with_file
