#if (_COLLISIONS_>0)
c======================================================================
c     Routines pour interpoler le resultat des collisons d'etoiles
c     Lecture et utilisation de la grille
c======================================================================
#define _TYPE_INTERP_SECONDAIRE_ 1 /* interpolattion multilineaire */
#define _SYM_M1_M2_ 1
c
c----------------------------------------------------------------------
      subroutine Lit_Tab_Interp_Res_Coll_ASC1(iFich,lStat)
c----------------------------------------------------------------------
c     Attention : Fragile !! Depend de l'ordre des donnees dans le fichier,
c     ne se sert pas des commentaires intercalaires pour fixer les indices...
c
      include 'interp_ResColl_exploit_inc.f'
c
c argument :
c ^^^^^^^^^^
      integer iFich
      logical lStat             ! indique si on a lu le "status" de chaque valeur
                                ! (cad non_specifiee/interpole/extrapolee)
c
c var locales :
c ^^^^^^^^^^^^^
      integer i,j,i1,i2,i3,i4,N1,N2,N3,N4,ifct,iVar,iEn_tete,
     $     Ntab_interp,l
      character*2048 Ligne
      character*64 Nom
c
c fonctions :
c ^^^^^^^^^^^
      integer LongChaine
c......................................................................
c 
      if (Nvar.NE.4) then       ! cette version ne marche que dans le cas de 4 variables
         write(0,*) '!!! Nvar different de 4 !!!'
         call Meurt('Lit_Tab_Interp_Res_Coll_ASC1')
      end if
      if (Nfct.NE.4) then       ! cette version ne marche que dans le cas de 4 fonctions
         write(0,*) '!!! Nfct different de 4 !!!'
         call Meurt('Lit_Tab_Inerp_Res_Coll_ASC1')
      end if

      read(iFich,'(A)',END=99) Ligne
c     
c---- initialisation des tableaux avant de lire le premier bloc
c     
      lStat=.FALSE.
      do i=1,Ntab_interp_max
         do ifct=1,Nfct
            tab_interp(i,ifct) = valeur_non_specifiee
            tab_stat_interp(i,ifct) = i_valeur_non_specifiee
         end do
      end do
      
      do i=1,4
         N_interp(i)=0
      end do
c     
c---- Il faut lire les specification de la grille dans l'en-tete du fichier
c     
      iEn_tete=0
      do while (Ligne(1:1).EQ.'#')
         l=LongChaine(Ligne)
         i=2
         call SauteBlancs(Ligne,i)
         
         if (Ligne(i:i+8).EQ.'variables') then
            i=i+9
            call SauteBlancs(Ligne,i)
            if (Ligne(i:i).EQ.':') i=i+1
            
            j=i
            do while (j.LE.l)
               call SauteBlancs(Ligne,i)
               if (Ligne(i:i).EQ.'X') then
                  i=i+1
                  j=i
                  do while (Ligne(j:j).NE.':') 
                     j=j+1
                  end do
                  read(Ligne(i:j-1),*) iVar
                  if (iVar.GT.0 .AND. iVar.LE.Nvar) then
                     i=j+1
                     call SauteBlancs(Ligne,i)
                     j=i
                     call SauteNonBlancs(Ligne,j)
                     NomsVar_ResColl(iVar)=Ligne(i:j-1)
                     i=j
                  else
                     call ErreurEnTeteTab(1)
                  end if
               else
                  call ErreurEnTeteTab(2)
               end if
            end do
            
            iEn_tete=iEn_tete+1
         else if (Ligne(i:i+8).EQ.'fonctions') then
            i=i+9
            call SauteBlancs(Ligne,i)
            if (Ligne(i:i).EQ.':') i=i+1
            
            j=i
            do while (j.LE.l)
               call SauteBlancs(Ligne,i)
               if (Ligne(i:i).EQ.'F') then
                  i=i+1
                  j=i
                  do while (Ligne(j:j).NE.':') 
                     j=j+1
                  end do
                  read(Ligne(i:j-1),*) iFct
                  if (iVar.GT.0 .AND. iFct.LE.Nfct) then
                     i=j+1
                     call SauteBlancs(Ligne,i)
                     j=i
                     call SauteNonBlancs(Ligne,j)
                     NomsFct_ResColl(iFct)=Ligne(i:j-1)
                     i=j
                  else
                     call ErreurEnTeteTab(3)
                  end if
               else
                  call ErreurEnTeteTab(4)
               end if
            end do
            
            iEn_tete=iEn_tete+1
         else if (Ligne(i:i+18).EQ.'Limites inferieures') then
            i=i+19
            call SauteBlancs(Ligne,i)
            if (Ligne(i:i).EQ.':') i=i+1
            call SauteBlancs(Ligne,i)
            call SauteNonBlancs(Ligne,i)
            call SauteBlancs(Ligne,i)
            if (Ligne(i:i).EQ.'=') i=i+1
            read(Ligne(i:l),*) Xmin_Interp

            iEn_tete=iEn_tete+1
         else if (Ligne(i:i+18).EQ.'Limites superieures') then
            i=i+19
            call SauteBlancs(Ligne,i)
            if (Ligne(i:i).EQ.':') i=i+1
            call SauteBlancs(Ligne,i)
            call SauteNonBlancs(Ligne,i)
            call SauteBlancs(Ligne,i)
            if (Ligne(i:i).EQ.'=') i=i+1
            read(Ligne(i:l),*) Xmax_Interp

            iEn_tete=iEn_tete+1
         else if (Ligne(i:i+9).EQ.'Dimensions') then
            i=i+10
            call SauteBlancs(Ligne,i)
            if (Ligne(i:i).EQ.':') i=i+1
            call SauteBlancs(Ligne,i)
            call SauteNonBlancs(Ligne,i)
            call SauteBlancs(Ligne,i)
            if (Ligne(i:i).EQ.'=') i=i+1
            read(Ligne(i:l),*) N_Interp

            iEn_tete=iEn_tete+1
         end if
         read(iFich,'(A)',END=99) Ligne
      end do
      if (iEn_tete.NE.5) then
         call ErreurEnTeteTab(5)
      end if
      
                                ! test sur la taille totale du tableau
      Ntab_interp=1
      do i=1,Nvar
         Ntab_interp=Ntab_interp*N_interp(i)
      end do
      if (Ntab_interp.GT.Ntab_interp_max) then
         write(0,*) '!!! Le nb max de points d''interpolation est ',
     $        Ntab_interp_max,' !!!'
         call Meurt('Lit_Tab_Interp_Res_Coll_ASC1')
      end if

#if (_VERB_INTERP_RESCOLL_>0)
         write(0,100) N_interp,Xmin_interp,Xmax_interp
 100     format(
     $        '> On lit une table de resultats',
     $        ' de collisions d''etoiles',
     $        /,
     $        '  de dimensions ',I3,',',I3,',',I3,',',I3,/,
     $        '  avec lim inferieures ',
     $        E11.4,',',E11.4,',',E11.4,',',E11.4,/,
     $        '    et lim superieures ',
     $        E11.4,',',E11.4,',',E11.4,',',E11.4,/,
     $        '  pour les variables :',/,'    ',$)
         do i=1,Nvar
            nom=NomsVar_ResColl(i)
            write(0,110) nom(1:LongChaine(nom))
 110        format(A,' ',$)
         end do
         write(0,120)
 120     format( /,'  et les "fonctions" :',/,'    ',$)
         do i=1,Nfct
            nom=NomsFct_ResColl(i)
            write(0,110) nom(1:LongChaine(nom))
         end do
         write(0,130)
 130     format(/)
#endif

      N1 = N_interp(1)
      N2 = N_interp(2)
      N3 = N_interp(3)
      N4 = N_interp(4)

      i1 = 1
      i2 = 1 
      i3 = 1
      ifct =1

      do while (.TRUE.)
         if (Ligne(1:1).NE.'#') then ! on saute les commentaires
            read(Ligne,*)
     $           (tab_interp(i1+N1*(i2-1+N2*(i3-1+N3*(i4-1))),ifct),
     $           i4=1,N4)
            do i4=1,N4
               if (tab_interp(i1+N1*(i2-1+N2*(i3-1+N3*(i4-1))),ifct).NE.
     $              valeur_non_specifiee) then
                  tab_stat_interp(i1+N1*(i2-1+N2*(i3-1+N3*(i4-1))),
     $                 ifct)=i_valeur_specifiee
               end if
            end do
            i3=i3+1
            if (i3.GT.N3) then
               i3 = 1
               ifct = ifct + 1
               if (ifct.GT.Nfct) then
                  ifct = 1
                  i2 = i2 + 1
                  if (i2.GT.N2) then
                     i1 = i1 + 1
#if (_SYM_M1_M2_>0)
                     i2 = i1
#else
                     i2 = 1
#endif
                  end if
               end if
            end if
         else if (Ligne(1:22).EQ.
     $           '#% VALEURS DES STATUS') then
            lStat=.TRUE.
#if (_VERB_INTERP_RESCOLL_>0)
            write(0,*) '> status specifies dans le fichier'
#endif
            goto 99
         end if
         read(iFich,'(A)',END=99) Ligne
      end do
 99   continue
c
c---- Lecture des status pour toute la grille si ils sont
c     specifiees dans le fichier
c
      if (lStat) then

         i1 = 1
         i2 = 1 
         i3 = 1
         ifct =1

         do while (.TRUE.)
            if (Ligne(1:1).NE.'#') then ! on saute les commentaires
               read(Ligne,*)
     $              (tab_stat_interp(i1+N1*(i2-1+N2*(i3-1+N3*(i4-1))),
     $              ifct),i4=1,N4)
               i3=i3+1
               if (i3.GT.N3) then
                  i3 = 1
                  ifct = ifct + 1
                  if (ifct.GT.Nfct) then
                     ifct = 1
                     i2 = i2 + 1
                     if (i2.GT.N2) then
                        i1 = i1 + 1
#if (_SYM_M1_M2_>0)
                        i2 = i1
#else 
                        i2 = 1
#endif
                     end if
                  end if
               end if
            end if
            read(iFich,'(A)',END=999) Ligne
         end do
 999     continue
      end if 

#if (_SYM_M1_M2_>0)
      call Symmetriser_X1X2
#endif
c
      end
c
c----------------------------------------------------------------------
      subroutine Lit_Bloc_Interp_Res_Coll_ASC1(iFich,lStat)
c----------------------------------------------------------------------
      include 'interp_ResColl_exploit_inc.f'
c
c argument :
c ^^^^^^^^^^
      integer iFich
      logical lStat             ! indique si le fichier contient le "status" de chaque valeur de la grille
                                ! (cad non_specofiee/interpole/extrapolee)
c
c
c var locales :
c ^^^^^^^^^^^^^
      integer i,j,i1,i2,i3,i4,N1,N2,N3,N4,ifct,iVar,iEn_tete,
     $     Ntab_interp,l, i_sym, iprov(Nfct)
      character*2048 Ligne
      character*64 nom
      real prov(Nfct)
      logical lPremBloc
      save lPremBloc
      data lPremBloc /.TRUE./
c
c fonctions :
c ^^^^^^^^^^^
      integer LongChaine
c......................................................................
c 
      if (Nvar.NE.4) then       ! cette version ne marche que dans le cas de 4 variables
         write(0,*) '!!! Nvar different de 4 !!!'
         call Meurt('Lit_Bloc_Interp_Res_Coll_ASC1')
      end if
      if (Nfct.NE.4) then       ! cette version ne marche que dans le cas de 4 fonctions
         write(0,*) '!!! Nfct different de 4 !!!'
         call Meurt('Lit_Bloc_Interp_Res_Coll_ASC1')
      end if

      read(iFich,'(A)',END=99) Ligne

      lStat = .FALSE.

      if (lPremBloc) then
c
c---- initialisation des tableaux avant de lire le premier bloc
c
         do i=1,Ntab_interp_max
            do ifct=1,Nfct
               tab_interp(i,ifct) = valeur_non_specifiee
               tab_stat_interp(i,ifct) = i_valeur_non_specifiee
            end do
         end do
         
         do i=1,4
            N_interp(i)=0
         end do
c
c---- Il faut lire les specification de la grille dans l'en-tete du fichier
c
         iEn_tete=0
         do while (Ligne(1:1).EQ.'#')
            l=LongChaine(Ligne)
            if (Ligne(1:l).EQ.'# avec specification du status') then
               lStat=.TRUE.
            else
               i=2
               call SauteBlancs(Ligne,i)
               
               if (Ligne(i:i+8).EQ.'variables') then
                  i=i+9
                  call SauteBlancs(Ligne,i)
                  if (Ligne(i:i).EQ.':') i=i+1
                  
                  j=i
                  do while (j.LE.l)
                     call SauteBlancs(Ligne,i)
                     if (Ligne(i:i).EQ.'X') then
                        i=i+1
                        j=i
                        do while (Ligne(j:j).NE.':') 
                           j=j+1
                        end do
                        read(Ligne(i:j-1),*) iVar
                        if (iVar.GT.0 .AND. iVar.LE.Nvar) then
                           i=j+1
                           call SauteBlancs(Ligne,i)
                           j=i
                           call SauteNonBlancs(Ligne,j)
                           NomsVar_ResColl(iVar)=Ligne(i:j-1)
                           i=j
                        else
                           call ErreurEnTeteBloc(1)
                        end if
                     else
                        call ErreurEnTeteBloc(2)
                     end if
                  end do
                  
                  iEn_tete=iEn_tete+1
               else if (Ligne(i:i+8).EQ.'fonctions') then
                  i=i+9
                  call SauteBlancs(Ligne,i)
                  if (Ligne(i:i).EQ.':') i=i+1
                  
                  j=i
                  do while (j.LE.l)
                     call SauteBlancs(Ligne,i)
                     if (Ligne(i:i).EQ.'F') then
                        i=i+1
                        j=i
                        do while (Ligne(j:j).NE.':') 
                           j=j+1
                        end do
                        read(Ligne(i:j-1),*) iFct
                        if (iVar.GT.0 .AND. iFct.LE.Nfct) then
                           i=j+1
                           call SauteBlancs(Ligne,i)
                           j=i
                           call SauteNonBlancs(Ligne,j)
                           NomsFct_ResColl(iFct)=Ligne(i:j-1)
                           i=j
                        else
                           call ErreurEnTeteBloc(3)
                        end if
                     else
                        call ErreurEnTeteBloc(4)
                     end if
                  end do
                  
                  iEn_tete=iEn_tete+1
               else if (Ligne(i:i+18).EQ.'Limites inferieures') then
                  i=i+19
                  call SauteBlancs(Ligne,i)
                  if (Ligne(i:i).EQ.':') i=i+1
                  call SauteBlancs(Ligne,i)
                  call SauteNonBlancs(Ligne,i)
                  call SauteBlancs(Ligne,i)
                  if (Ligne(i:i).EQ.'=') i=i+1
                  read(Ligne(i:l),*) Xmin_Interp
                  
                  iEn_tete=iEn_tete+1
               else if (Ligne(i:i+18).EQ.'Limites superieures') then
                  i=i+19
                  call SauteBlancs(Ligne,i)
                  if (Ligne(i:i).EQ.':') i=i+1
                  call SauteBlancs(Ligne,i)
                  call SauteNonBlancs(Ligne,i)
                  call SauteBlancs(Ligne,i)
                  if (Ligne(i:i).EQ.'=') i=i+1
                  read(Ligne(i:l),*) Xmax_Interp
                  
                  iEn_tete=iEn_tete+1
               else if (Ligne(i:i+17).EQ.'Dimensions totales') then
                  i=i+18
                  call SauteBlancs(Ligne,i)
                  if (Ligne(i:i).EQ.':') i=i+1
                  call SauteBlancs(Ligne,i)
                  call SauteNonBlancs(Ligne,i)
                  call SauteBlancs(Ligne,i)
                  if (Ligne(i:i).EQ.'=') i=i+1
                  read(Ligne(i:l),*) N_Interp
                  
                  iEn_tete=iEn_tete+1
               end if
            end if
            read(iFich,'(A)',END=99) Ligne
         end do
         if (iEn_tete.NE.5) then
            call ErreurEnTeteBloc(5)
         end if
         
                                ! test sur la taille totale du tableau
         Ntab_interp=1
         do i=1,Nvar
            Ntab_interp=Ntab_interp*N_interp(i)
         end do
         if (Ntab_interp.GT.Ntab_interp_max) then
            write(0,*) '!!! Le nb max de points d''interpolation est ',
     $           Ntab_interp_max,' !!!'
            call Meurt('Lit_Bloc_Interp_Res_Coll_ASC1')
         end if

#if (_VERB_INTERP_RESCOLL_>0)
         write(0,100) N_interp,Xmin_interp,Xmax_interp
 100     format(
     $        '> On lit des blocs pour une table de resultats',
     $        ' de collisions d''etoiles',
     $        /,
     $        '  de dimensions ',I3,',',I3,',',I3,',',I3,/,
     $        '  avec lim inferieures ',
     $        E11.4,',',E11.4,',',E11.4,',',E11.4,/,
     $        '    et lim superieures ',
     $        E11.4,',',E11.4,',',E11.4,',',E11.4,/,
     $        '  pour les variables :',/,'    ',$)
         do i=1,Nvar
            nom=NomsVar_ResColl(i)
            write(0,110) nom(1:LongChaine(nom))
 110        format(A,' ',$)
         end do
         write(0,120)
 120     format( /,'  et les "fonctions" :',/,'    ',$)
         do i=1,Nfct
            nom=NomsFct_ResColl(i)
            write(0,110) nom(1:LongChaine(nom))
         end do
         write(0,130)
 130     format(/)
         if (lStat) then
            write(0,135)
 135        format('  Avec specification du status')
         end if
#endif

         lPremBloc = .FALSE.
      end if

      N1 = N_interp(1)
      N2 = N_interp(2)
      N3 = N_interp(3)
      N4 = N_interp(4)

      do while (.TRUE.)
         if (Ligne(1:1).NE.'#') then ! on saute les commentaires

            if (lStat) then
               read(Ligne,*) i1,i2,i3,i4,(prov(ifct),ifct=1,Nfct),
     $              (iprov(ifct),ifct=1,Nfct)
            else
               read(Ligne,*) i1,i2,i3,i4,(prov(ifct),ifct=1,Nfct)
            end if
            i=i1+N1*(i2-1+N2*(i3-1+N3*(i4-1)))
            if (i1.GT.N1 .OR. i2.GT.N2 .OR. i3.GT.N3 .OR. i4.GT.N4) then
               write(0,*) '!!! indice(s) depassant ',
     $              'les limites de la grille !!!'
               call Meurt('Lit_Bloc_Interp_Res_Coll_ASC1')
            end if
            do ifct=1,Nfct
               tab_interp(i,ifct) = prov(ifct)
               if (lStat) then
                  tab_stat_interp(i,ifct) = iprov(ifct)
               else
                  if (tab_interp(i,ifct).NE.valeur_non_specifiee)
     $                 tab_stat_interp(i,ifct) = i_valeur_specifiee
               end if
            end do
#if (_SYM_M1_M2_>0)
            if(i2.NE.i1) then
               i_sym=i2+N1*(i1-1+N2*(i3-1+N3*(i4-1)))
               do ifct=1,Nfct
                  tab_interp(i_sym,ifct) = tab_interp(i,ifct)
                  tab_stat_interp(i_sym,ifct) = tab_stat_interp(i,ifct)
               end do
            end if
#endif
         end if
         read(iFich,'(A)',END=99) Ligne
      end do
 99   continue
c
      end
c
c------------------------------------------------------------
      subroutine ErreurEnTeteTab(ierr)
c------------------------------------------------------------
      implicit none
      integer ierr
      write(0,*)
     $     '!!! Fichier de bloc de grille avec en-tete incorrecte (',
     $     ierr,') !!!'
      call Meurt('Lit_Tab_Interp_Res_Coll_ASC1')
c
      end
c
c------------------------------------------------------------
      subroutine ErreurEnTeteBloc(ierr)
c------------------------------------------------------------
      implicit none
      integer ierr
      write(0,*)
     $     '!!! Fichier de bloc de grille avec en-tete incorrecte (',
     $     ierr,') !!!'
      call Meurt('Lit_Bloc_Interp_Res_Coll_ASC1')
c
      end
c
c----------------------------------------------------------------------
      subroutine Lit_Tab_Interp_Res_Coll_BIN1(iFich,lStat)
c----------------------------------------------------------------------
      include 'interp_ResColl_exploit_inc.f'
c
c argument :
c ^^^^^^^^^^
      integer iFich
      logical lStat             ! indique si le fichier contient le "status" de chaque valeur de la grille
                                ! (cad non_specofiee/interpole/extrapolee)
c
c var locales :
c ^^^^^^^^^^^^^
      integer Ntab_interp,i1,i2,i3,i4,N1,N2,N3,N4,ifct,i,idum
      character*64 Chaine
c......................................................................
c 
      if (Nvar.NE.4) then       ! cette version ne marche que dans le cas de 4 variables
         write(0,*) '!!! Nvar different de 4 !!!'
         call Meurt('Lit_Tab_Interp_Res_Coll_BIN1')
      end if
      lStat = .FALSE.

      read(iFich) NomsVar_ResColl ! les noms des variables
      read(iFich) NomsFct_ResColl ! les noms des "fonctions"
      read(iFich) Xmin_interp  ! les limites inferieures
      read(iFich) Xmax_interp  ! les limites superieures
      read(iFich) N_interp     ! les dimensions de la grille

      Ntab_interp=1
      do i=1,Nvar
         Ntab_interp=Ntab_interp*N_interp(i)
      end do
      if (Ntab_interp.GT.Ntab_interp_max) then
         write(0,*) '!!! Le nb max de points d''interpolation est ',
     $       Ntab_interp_max,' !!!'
         call Meurt('Lit_Tab_Interp_Res_Coll_BIN1')
      end if
c
c---- Initialisation de la grille
c
      do ifct=1,Nfct
         do i=1,Ntab_interp
            tab_interp(i,ifct) = valeur_non_specifiee
            tab_stat_interp(i,ifct) = i_valeur_non_specifiee
         end do
      end do
      
      N1 = N_interp(1)
      N2 = N_interp(2)
      N3 = N_interp(3)
      N4 = N_interp(4)

#if (_SYM_M1_M2_>0)
      if (N1.NE.N2) then
         write(0,*) '!!! Structure de table incorrecte avec N1<>N2 !!!'
         call Meurt('Lit_Tab_Interp_Res_Coll_BIN1')
      end if
#endif
c
c---- Lecture des valeurs des "fonctions"
c
      do i1=1,N1
         do i2=1,N2
#if (_SYM_M1_M2_>0)
            if (i2.GE.i1) then
#endif
               do ifct=1,Nfct
                  read(iFich,END=999,ERR=999) idum
                  read(iFich) ((
     $                 tab_interp(i1+N1*(i2-1+N2*(i3-1+N3*(i4-1))),
     $                 ifct),i3=1,N3),i4=1,N4)
                  do i3=1,N3
                     do i4=1,N4
                        if (tab_interp(i1+N1*(i2-1+N2*(i3-1+N3*(i4-1))),
     $                       ifct).NE.valeur_non_specifiee) then
                           tab_stat_interp(
     $                          i1+N1*(i2-1+N2*(i3-1+N3*(i4-1))),ifct)=
     $                          i_valeur_specifiee
                        end if
                     end do
                  end do
               end do
#if (_SYM_M1_M2_>0)
            end if
#endif
         end do
      end do
c
c---- Lecture des valeurs des "status" si elles sont specifiees dans le fichier
c
      Chaine=''
      read(iFich,END=99,ERR=99)
     $     Chaine(1:8)          ! Il faut lire exactement le bon nb de caracteres
                                ! dans un fichier binaire !!!
      if (Chaine.EQ.'# status') lStat=.TRUE.

      if (lStat) then
         do i1=1,N1
            do i2=1,N2
#if (_SYM_M1_M2_>0)
               if (i2.GE.i1) then
#endif
                  do ifct=1,Nfct
                     read(iFich,END=999,ERR=999) idum
                     read(iFich) ((
     $                    tab_stat_interp(
     $                    i1+N1*(i2-1+N2*(i3-1+N3*(i4-1))),ifct),
     $                    i3=1,N3),i4=1,N4)
                  end do
#if (_SYM_M1_M2_>0)
               end if
#endif
            end do
         end do
      end if
 99   continue

#if (_SYM_M1_M2_>0)
      call Symmetriser_X1X2
#endif

#if (_VERB_INTERP_RESCOLL_>0)
      write(0,100) N_interp
 100  format(
     $        '> On a lu une table de resultats de collisions d''etoiles',
     $     /,
     $     '  de dimensions ',I3,',',I3,',',I3,',',I3,/,
     $     '  pour les variables :',/,'    ',$)
      do i=1,Nvar
         write(0,110)
     $        NomsVar_ResColl(i)(1:index(NomsVar_ResColl(i),' ')-1)
 110     format(A,' ',$)
      end do
      write(0,120)
 120  format( /,'  et les "fonctions" :',/,'    ',$)
      do i=1,Nfct
         write(0,110) 
     $        NomsFct_ResColl(i)(1:index(NomsFct_ResColl(i),' ')-1)
      end do
      write(0,130)
 130  format(/)
      if (lStat) then
         write(0,135)
 135     format('  Avec specification du status')
      end if
#endif
      return
c
c---- En cas d'erreur de lecture....
c
 999  write(0,*) '!!! Erreur de lecture !!!'
      call Meurt('Lit_Tab_Interp_Res_Coll_BIN1')
c
      end
c
c----------------------------------------------------------------------
      subroutine Symmetriser_X1X2
c----------------------------------------------------------------------
      include 'interp_ResColl_exploit_inc.f'
c
c variables locales :
c ^^^^^^^^^^^^^^^^^^^
      integer i1,i2,i3,i4,ifct,N1,N2,N3
c......................................................................
c
      N1 = N_interp(1)
      N2 = N_interp(2)
      N3 = N_interp(3)
      do i1=1,N1
         do i2=i1+1,N2
            do i3=1,N3
               do i4=1,N_interp(4)
                  do ifct=1,Nfct
                     tab_interp(i2+N1*(i1-1+N2*(i3-1+N3*(i4-1))),
     $                    ifct) = tab_interp(
     $                    i1+N1*(i2-1+N2*(i3-1+N3*(i4-1))),ifct)
                     tab_stat_interp(i2+N1*(i1-1+N2*(i3-1+N3*(i4-1))),
     $                    ifct) = tab_stat_interp(
     $                    i1+N1*(i2-1+N2*(i3-1+N3*(i4-1))),ifct)
                  end do
               end do
            end do
         end do
      end do
c
      end
c                     
c----------------------------------------------------------------------
      subroutine Lit_EnTete_Interp_Res_Coll_BIN1(iFich)
c----------------------------------------------------------------------
      include 'interp_ResColl_exploit_inc.f'
c
c argument :
c ^^^^^^^^^^
      integer iFich
c......................................................................
c 
      if (Nvar.NE.4) then       ! cette version ne marche que dans le cas de 4 variables
         write(0,*) '!!! Nvar different de 4 !!!'
         call Meurt('Lit_EnTete_Interp_Res_Coll_BIN1')
      end if

      read(iFich) NomsVar_ResColl ! les noms des variables
      read(iFich) NomsFct_ResColl ! les noms des "fonctions"
      read(iFich) Xmin_interp  ! les limites inferieures
      read(iFich) Xmax_interp  ! les limites superieures
      read(iFich) N_interp     ! les dimensions de la grille
c
      end
c
#if (_TYPE_INTERP_SECONDAIRE_==1) /* interpolation multilineaire */
c----------------------------------------------------------------------
      subroutine Interp_ResColl_Grille(Xi,Fi,istat)
c----------------------------------------------------------------------
      include 'interp_ResColl_exploit_inc.f'
c
c arguments :
c ^^^^^^^^^^^
      real
     $     Xi(Nvar),            ! La valeur des variables pour lesquelles on veut calculer les "fonctions"
     $     Fi(Nfct)             ! La valeur interpoler des "fonctions" a calculer
      integer istat(Nfct)       ! Indique, pour chaque "fonction", si il s'agit d'une valeur interpolee,
                                ! extrapolee ou non definie
c
c constantes :
c ^^^^^^^^^^^^
      integer iFich_HorsGrille
      parameter (iFich_HorsGrille=19)
c
c var locales :
c ^^^^^^^^^^^^^
      real Wi, UnSurdX(Nvar), valeur_grille,
     $     c_multlin(Nvar), Xi_(Nvar)
      integer iVar,ifct,i,ind_cell(Nvar),ind_pt(Nvar),ig
      logical lPrem, lHors_Grille
      save UnSurdX, lPrem
      data lPrem /.TRUE./
c
c fonctions :
c ^^^^^^^^^^^
      integer indice_grille     ! Fournit l'indice dans la grille en fct
                                ! d'un quadruplet d'indices
c......................................................................
c
c---- Initialisations
c
      if (lPrem) then
         do iVar=1,Nvar
            UnSurdX(iVar)=float(N_interp(iVar)-1)/
     $           (Xmax_interp(iVar)-Xmin_interp(iVar))
         end do
         open(iFich_HorsGrille,file='HorsGrille_Interp_ResColl.asc')
         write(iFich_HorsGrille,100)
 100     format(
     $        '# Cas hors interpolation dans Interp_ResColl_Grille',/,
     $        '# 1:X1 2:X2 3:X3 4:X4 5:F1 6:F2 7:F3 8:F4 9:istat')
         lPrem = .FALSE.
      end if
      do ifct=1,Nfct
         istat(ifct) = i_valeur_interpolee
         Fi(ifct) = 0.0
      end do
      do iVar=1,Nvar
         Xi_(iVar)=Xi(iVar)
      end do
      lHors_Grille=.FALSE.
c
c---- Determination de la position dans la grille
c
      do iVar=1,Nvar
         if (Xi_(iVar).GE.Xmin_interp(iVar)) then
            ind_cell(iVar) = int(UnSurdX(iVar)*
     $           (Xi_(iVar)-Xmin_interp(iVar)))+1
         else
            ind_cell(iVar) = 0
         end if
      end do
c
c     Si on sort de la grille pour une des deux premieres variables,
c     qui representent les masses, on ne peut pas calculer le resultat
c
      if (ind_cell(1).LT.1 .OR. ind_cell(1).GE.N_interp(1) .OR.
     $     ind_cell(2).LT.1 .OR. ind_cell(2).GE.N_interp(2)) then
         lHors_Grille=.TRUE.
c
c     De meme, si la variable 4 est trop grande (parametre d'impact)
c
      else if (ind_cell(4).GE.N_interp(4)) then
         lHors_Grille=.TRUE.
c
c     Si la variable 4 est trop petite, on se permet de se placer a la limite
c     inferieure de la grille (collision frontale ou presque)
c
      else
         if (ind_cell(4).LT.1) then
            ind_cell(4)=1
            Xi_(4)=Xmin_interp(4)
            do ifct=1,Nfct
               istat(ifct)=i_valeur_extrapolee
            end do
         end if
c
c     Si la variable 3 est trop petite, on se permet de se placer a la limite
c     inferieure de la grille (vitesse relative nulle initialement)
c
         if (ind_cell(3).LT.1) then
            ind_cell(3)=1
            Xi_(3)=Xmin_interp(3)
            do ifct=1,Nfct
               istat(ifct)=i_valeur_extrapolee
            end do
c
c     Si la variable 4 est trop grande, on se permet de se placer a la limite
c     superieure de la grille (vitesse relative tres grande). Ceci n'est pas
c     bien justifie physiquement, mais a defaut d'une meilleure idee...
c
         else if (ind_cell(3).GE.N_interp(3)) then
            ind_cell(3)=N_interp(3)-1
            Xi_(3)=Xmax_interp(3)
            do ifct=1,Nfct
               istat(ifct)=i_valeur_extrapolee
            end do
         end if
      end if
      if (lHors_Grille) then
         do ifct=1,Nfct
            Fi(ifct)=valeur_non_specifiee
            istat(ifct)=i_valeur_non_specifiee
         end do
      else
c
c---- Interpolation si on est dans la grille: il faut calculer
c     la contribution des 2**Nvar=16 points de la grille encadrant
c     le point.
c
         do iVar=1,Nvar
            ind_pt(iVar)=ind_cell(iVar)
            c_multlin(iVar)=UnSurdX(iVar)*(Xmin_interp(iVar)-Xi_(iVar))+
     $           ind_cell(iVar)
         end do
                                ! on passe en revue les pts voisins de la grille
                                ! ==============================================
         do i=1,2**Nvar
            
            Wi = 1.0
            do iVar=1,NVar
               Wi=Wi*c_multlin(iVar)
            end do
            ig = indice_grille(ind_pt)
            do ifct=1,Nfct
               valeur_grille = tab_interp(ig,ifct)
               if (istat(ifct).NE.i_valeur_non_specifiee) then
                  if (valeur_grille.LT.valeur_non_specifiee) then
                                ! contribution du pt de la grille aux valeurs interpolees
                     if (ifct.EQ.1) then
                                ! On traite specialement la "fct" 1 car il s'agit du log de la perte de masse
                        Fi(ifct) = Fi(ifct) + Wi*10**valeur_grille
                     else
                        Fi(ifct) = Fi(ifct) + Wi*valeur_grille
                     end if
                     if (tab_stat_interp(ig,ifct).EQ.
     $                    i_valeur_extrapolee) then
                        istat(ifct)=i_valeur_extrapolee
                     end if
                  else
                     istat(ifct)=i_valeur_non_specifiee
                  end if
               end if
            end do
                                ! incrementation pour passer au pt voisin suivant
            do iVar=1,Nvar
               if (ind_pt(iVar).EQ.ind_cell(iVar)) then
                  ind_pt(iVar)=ind_cell(iVar)+1
                  c_multlin(iVar)=1.0-c_multlin(iVar)
                  goto 9
               else
                  ind_pt(iVar)=ind_cell(iVar)
                  c_multlin(iVar)=1.0-c_multlin(iVar)
               end if
            end do
 9          continue
            
         end do         
      end if

      do ifct=1,Nfct
         if (istat(ifct).EQ.i_valeur_non_specifiee) then
            Fi(ifct) = valeur_non_specifiee
         else
            if (ifct.EQ.1) then
               Fi(ifct) = log10(Fi(ifct))
            end if
         end if
      end do
      if (istat(1).NE.10)
     $     write(iFich_HorsGrille,'(8(E10.3," "),4(I2," "))')
     $     Xi,Fi,istat
c
      end
c
#endif /* if (_TYPE_INTERP_SECONDAIRE_==1) interpolation multilineaire */

#if (_TYPE_INTERP_SECONDAIRE_==2) /* interpolation par noyaux */
c----------------------------------------------------------------------
      subroutine Interp_ResColl_Grille(Xi,Fi,iFlag)
c----------------------------------------------------------------------
      include 'interp_ResColl_exploit_inc.f'
c
c arguments :
c ^^^^^^^^^^^
      real
     $     Xi(Nvar),            ! La valeur des variables pour lesquelles on veut calculer les "fonctions"
     $     Fi(Nfct)             ! La valeur interpoler des "fonctions" a calculer
      integer iFlag       ! Indique si l'on se trouve dans la grille (1)
                                ! ou en dehors (0), auquel cas une extrapolation est realisee 
c
c constantes :
c ^^^^^^^^^^^^
      real h_W, UnSurh_W
      parameter (h_W=0.5,UnSurh_W=1.0/h_W) ! taille du noyau W en unites du pas de la grille
      real PiSur2
      parameter (PiSur2=1.570796327)
c
c var locales :
c ^^^^^^^^^^^^^
      real UnSurh, d2, d2_max, UnSurWtot, Wi, UnSurdX(Nvar),
     $     valeur_grille
      integer iVar,ifct,i,iPasse,ind_cell(Nvar),ind_pt(Nvar)
      logical lPrem, lNon_spec
      save UnSurdX, lPrem
      data lPrem /.TRUE./
c
c fonctions :
c ^^^^^^^^^^^
      real W                    ! noyau d'interpolation non normalise
                                ! defini dans le fichier interp_irreg.f
      integer indice_grille     ! Fournit l'indice dans la grille en fct
                                ! d'un quadruplet d'indices
c......................................................................
c
c---- Determination de la position dans la grille
c
      if (lPrem) then
         do iVar=1,Nvar
            UnSurdX(iVar)=float(N_interp(iVar)-1)/
     $           (Xmax_interp(iVar)-Xmin_interp(iVar))
         end do
         lPrem = .FALSE.
      end if

      iFlag = 1
      do iVar=1,Nvar
         if (Xi_(iVar).GE.Xmin_interp(iVar)) then
            ind_cell(iVar) = int(UnSurdX(iVar)*
     $           (Xi(iVar)-Xmin_interp(iVar)))+1
         else
            ind_cell(iVar) = 0
         end if
         if (ind_cell(iVar).LT.1) then
            iFlag = 0
            ind_cell(iVar)=1
         else if (ind_cell(iVar).GE.N_interp(iVar)) then
            iFlag = 0
            ind_cell(iVar)=N_interp(iVar)-1
         end if
      end do
      !!!write(0,*0 '!!!!!',ind_cell !#######
c
c---- Interpolation si on est dans la grille: il faut calculer
c     la contribution des 2**Nvar=16 points de la grille encadrant
c     le point.
c
c     On tente une extrapolation si on est en dehors de la grille
c     Dans ce cas, on se refere a la cellule de la grille qui est
c     la "plus proche" (en metrique du pas de la grille)
c
c     (cette routine est OK pour un nb quelconques de variables
c     et pas seulement 4!)
c
      UnSurh = UnSurh_W
      iPasse = 1
      
      do while (iPasse.LE.2)    ! astuce pour faire deux passes en cas d'extrapolation 
         
         do ifct=1,Nfct
            Fi(ifct)=0.0
         end do
         UnSurWtot = 0.0
         d2_max = 0.0
                                ! initialisation des indices du pt voisin
         do iVar=1,Nvar
            ind_pt(iVar)=ind_cell(iVar)
            c_multlin(iVar)=UnSurdX(iVar)*(Xmin_interp(iVar)-Xi(iVar))+
     $           ind_cell(iVar) ! pour interpolation multilineaire
         end do
                                ! on passe en revue les pts voisins de la grille
                                ! ==============================================
         lNon_spec=.FALSE.
                     
         do i=1,2**Nvar
            
            d2 = 0.0
            do iVar=1,NVar
               d2 = d2 + ( UnSurdX(iVar)*(Xi(iVar)
     $              -Xmin_interp(iVar))-ind_pt(iVar)+1.0 )**2
            end do
            d2_max = max(d2_max,d2)
            Wi = W(UnSurh*sqrt(d2))
            lNon_spec=.FALSE.
            do ifct=1,Nfct
               valeur_grille = tab_interp(indice_grille(ind_pt),ifct)
               if (valeur_grille.LT.valeur_non_specifiee) then
                  Fi(ifct) = Fi(ifct) + Wi*valeur_grille
               else
                  lNon_spec = .TRUE.
               end if
            end do
            if (.NOT.lNon_spec) UnSurWtot = UnSurWtot + Wi
                                ! incrementation pour passer au pt voisin suivant
            do iVar=1,Nvar
               if (ind_pt(iVar).EQ.ind_cell(iVar)) then
                  ind_pt(iVar)=ind_cell(iVar)+1
                  goto 9
               else
                  ind_pt(iVar)=ind_cell(iVar)
               end if
            end do
 9          continue
            
         end do
         
         if (iFlag.EQ.1) then
            iPasse = 3          ! on ne veut pas faire de second passage
         else
            iPasse = iPasse+1
            UnSurh = 2.0/sqrt(d2_max)
         end if
         
      end do
                                ! normalisation
      if (UnSurWtot.GT.0.0) then
         UnSurWtot = 1.0/UnSurWtot
         do ifct=1,Nfct
            Fi(ifct) = UnSurWtot*Fi(ifct)
         end do
      else
         iFlag=-iFlag
         do ifct=1,Nfct
            Fi(ifct) = valeur_non_specifiee
         end do
      end if
c
      end
c
#endif /* if (_TYPE_INTERP_SECONDAIRE_==2) interpolation par noyaux */
c
c----------------------------------------------------------------------
      integer function indice_grille(ind)
c----------------------------------------------------------------------
      include 'interp_ResColl_exploit_inc.f'
c
c arguments :
c ^^^^^^^^^^^
      integer ind(Nvar)
c
c var locales :
c ^^^^^^^^^^^^^
      integer ivar
c......................................................................
c
      indice_grille = 0
      do ivar = Nvar,1,-1
         indice_grille = indice_grille*N_interp(iVar) + ind(ivar)-1
      end do
      indice_grille = indice_grille + 1
c
      end
c
c----------------------------------------------------------------------
      integer function indice_grille4(i1,i2,i3,i4)
c----------------------------------------------------------------------
      include 'interp_ResColl_exploit_inc.f'
c
c arguments :
c ^^^^^^^^^^^
      integer i1,i2,i3,i4
c......................................................................
c
      indice_grille4 =
     $     i1+N_interp(1)*(i2-1+N_interp(2)*(i3-1+N_interp(3)*(i4-1)))
c
      end
c
#endif
