#!/usr/bin/env zsh

cat <<EOF
c----------------------------------------------------------------------
      subroutine WritePreprocDefines(iOut,FileName)
c----------------------------------------------------------------------
c     code generated by $0 
c     on $(hostname)
c     date $(date)
c
      implicit none
      integer iOut
      character*(*) FileName
c......................................................................
c
      open(iOut,file=FileName)
      write(iOut,120)
 120  format(
     $     '        Values of preprocessor variables'/,
     $     '******************************************************',/,
     $     '  script: $0',/,
     $     '  run on: $(hostname)',/,
     $     '  date  : $(date)',/,
     $     '******************************************************',/)

EOF


gawk '
   /^>>/ {
      print ""
      print "c   --------------------------"
      print "      write(iOut,110)"
      print "     &     '\''"$(NF-1)"'\''"
      print ""
   }
   NF==2 {
      print "      write(iOut,100)"
      print "     &     '\''"$1"'\'',"$2
   }
'
cat <<EOF

 100  format(A32,' : ',I2)
      close(iOut)
 110  format(/,
     $     '== In file : ',A,/,
     $     '========================================')
      close(iOut)
c
      end
c      
EOF